/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.runtime.io;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.LogFactory;
import software.amazon.awssdk.AbortedException;
import software.amazon.awssdk.internal.io.Releasable;
import software.amazon.awssdk.runtime.MetricAware;
import software.amazon.awssdk.util.SdkRuntime;
import software.amazon.awssdk.utils.IoUtils;

public abstract class SdkInputStream
extends InputStream
implements MetricAware,
Releasable {
    protected abstract InputStream getWrappedInputStream();

    @Override
    public final boolean isMetricActivated() {
        InputStream in = this.getWrappedInputStream();
        if (in instanceof MetricAware) {
            MetricAware metricAware = (MetricAware)((Object)in);
            return metricAware.isMetricActivated();
        }
        return false;
    }

    protected final void abortIfNeeded() {
        if (SdkRuntime.shouldAbort()) {
            try {
                this.abort();
            }
            catch (IOException e) {
                LogFactory.getLog(this.getClass()).debug("FYI", e);
            }
            throw new AbortedException();
        }
    }

    protected void abort() throws IOException {
    }

    @Override
    public void release() {
        IoUtils.closeQuietly(this, null);
        InputStream in = this.getWrappedInputStream();
        if (in instanceof Releasable) {
            Releasable r = (Releasable)((Object)in);
            r.release();
        }
    }
}

