/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.runtime.transform;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Date;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.util.DateUtils;
import software.amazon.awssdk.utils.Base64Utils;

@SdkInternalApi
public class SimpleTypeJsonUnmarshallers {

    public static class ShortJsonUnmarshaller
    implements Unmarshaller<Short, JsonUnmarshallerContext> {
        private static final ShortJsonUnmarshaller INSTANCE = new ShortJsonUnmarshaller();

        public static ShortJsonUnmarshaller getInstance() {
            return INSTANCE;
        }

        @Override
        public Short unmarshall(JsonUnmarshallerContext unmarshallerContext) throws Exception {
            String shortString = unmarshallerContext.readText();
            return shortString == null ? null : Short.valueOf(shortString);
        }
    }

    public static class CharacterJsonUnmarshaller
    implements Unmarshaller<Character, JsonUnmarshallerContext> {
        private static final CharacterJsonUnmarshaller INSTANCE = new CharacterJsonUnmarshaller();

        public static CharacterJsonUnmarshaller getInstance() {
            return INSTANCE;
        }

        @Override
        public Character unmarshall(JsonUnmarshallerContext unmarshallerContext) throws Exception {
            String charString = unmarshallerContext.readText();
            if (charString == null) {
                return null;
            }
            if ((charString = charString.trim()).isEmpty() || charString.length() > 1) {
                throw new SdkClientException("'" + charString + "' cannot be converted to Character");
            }
            return Character.valueOf(charString.charAt(0));
        }
    }

    public static class ByteBufferJsonUnmarshaller
    implements Unmarshaller<ByteBuffer, JsonUnmarshallerContext> {
        private static final ByteBufferJsonUnmarshaller INSTANCE = new ByteBufferJsonUnmarshaller();

        public static ByteBufferJsonUnmarshaller getInstance() {
            return INSTANCE;
        }

        @Override
        public ByteBuffer unmarshall(JsonUnmarshallerContext unmarshallerContext) throws Exception {
            String base64EncodedString = unmarshallerContext.readText();
            if (base64EncodedString == null) {
                return null;
            }
            byte[] decodedBytes = Base64Utils.decode(base64EncodedString);
            return ByteBuffer.wrap(decodedBytes);
        }
    }

    public static class DateJsonUnmarshaller
    implements Unmarshaller<Date, JsonUnmarshallerContext> {
        private static final DateJsonUnmarshaller INSTANCE = new DateJsonUnmarshaller();

        public static DateJsonUnmarshaller getInstance() {
            return INSTANCE;
        }

        @Override
        public Date unmarshall(JsonUnmarshallerContext unmarshallerContext) throws Exception {
            return DateUtils.parseServiceSpecificDate(unmarshallerContext.readText());
        }
    }

    public static class ByteJsonUnmarshaller
    implements Unmarshaller<Byte, JsonUnmarshallerContext> {
        private static final ByteJsonUnmarshaller INSTANCE = new ByteJsonUnmarshaller();

        public static ByteJsonUnmarshaller getInstance() {
            return INSTANCE;
        }

        @Override
        public Byte unmarshall(JsonUnmarshallerContext unmarshallerContext) throws Exception {
            String byteString = unmarshallerContext.readText();
            return byteString == null ? null : Byte.valueOf(byteString);
        }
    }

    public static class LongJsonUnmarshaller
    implements Unmarshaller<Long, JsonUnmarshallerContext> {
        private static final LongJsonUnmarshaller INSTANCE = new LongJsonUnmarshaller();

        public static LongJsonUnmarshaller getInstance() {
            return INSTANCE;
        }

        @Override
        public Long unmarshall(JsonUnmarshallerContext unmarshallerContext) throws Exception {
            String longString = unmarshallerContext.readText();
            return longString == null ? null : Long.valueOf(Long.parseLong(longString));
        }
    }

    public static class FloatJsonUnmarshaller
    implements Unmarshaller<Float, JsonUnmarshallerContext> {
        private static final FloatJsonUnmarshaller INSTANCE = new FloatJsonUnmarshaller();

        public static FloatJsonUnmarshaller getInstance() {
            return INSTANCE;
        }

        @Override
        public Float unmarshall(JsonUnmarshallerContext unmarshallerContext) throws Exception {
            String floatString = unmarshallerContext.readText();
            return floatString == null ? null : Float.valueOf(floatString);
        }
    }

    public static class BooleanJsonUnmarshaller
    implements Unmarshaller<Boolean, JsonUnmarshallerContext> {
        private static final BooleanJsonUnmarshaller INSTANCE = new BooleanJsonUnmarshaller();

        public static BooleanJsonUnmarshaller getInstance() {
            return INSTANCE;
        }

        @Override
        public Boolean unmarshall(JsonUnmarshallerContext unmarshallerContext) throws Exception {
            String booleanString = unmarshallerContext.readText();
            return booleanString == null ? null : Boolean.valueOf(Boolean.parseBoolean(booleanString));
        }
    }

    public static class BigDecimalJsonUnmarshaller
    implements Unmarshaller<BigDecimal, JsonUnmarshallerContext> {
        private static final BigDecimalJsonUnmarshaller INSTANCE = new BigDecimalJsonUnmarshaller();

        public static BigDecimalJsonUnmarshaller getInstance() {
            return INSTANCE;
        }

        @Override
        public BigDecimal unmarshall(JsonUnmarshallerContext unmarshallerContext) throws Exception {
            String s = unmarshallerContext.readText();
            return s == null ? null : new BigDecimal(s);
        }
    }

    public static class BigIntegerJsonUnmarshaller
    implements Unmarshaller<BigInteger, JsonUnmarshallerContext> {
        private static final BigIntegerJsonUnmarshaller INSTANCE = new BigIntegerJsonUnmarshaller();

        public static BigIntegerJsonUnmarshaller getInstance() {
            return INSTANCE;
        }

        @Override
        public BigInteger unmarshall(JsonUnmarshallerContext unmarshallerContext) throws Exception {
            String intString = unmarshallerContext.readText();
            return intString == null ? null : new BigInteger(intString);
        }
    }

    public static class IntegerJsonUnmarshaller
    implements Unmarshaller<Integer, JsonUnmarshallerContext> {
        private static final IntegerJsonUnmarshaller INSTANCE = new IntegerJsonUnmarshaller();

        public static IntegerJsonUnmarshaller getInstance() {
            return INSTANCE;
        }

        @Override
        public Integer unmarshall(JsonUnmarshallerContext unmarshallerContext) throws Exception {
            String intString = unmarshallerContext.readText();
            return intString == null ? null : Integer.valueOf(Integer.parseInt(intString));
        }
    }

    public static class DoubleJsonUnmarshaller
    implements Unmarshaller<Double, JsonUnmarshallerContext> {
        private static final DoubleJsonUnmarshaller INSTANCE = new DoubleJsonUnmarshaller();

        public static DoubleJsonUnmarshaller getInstance() {
            return INSTANCE;
        }

        @Override
        public Double unmarshall(JsonUnmarshallerContext unmarshallerContext) throws Exception {
            String doubleString = unmarshallerContext.readText();
            return doubleString == null ? null : Double.valueOf(Double.parseDouble(doubleString));
        }
    }

    public static class StringJsonUnmarshaller
    implements Unmarshaller<String, JsonUnmarshallerContext> {
        private static final StringJsonUnmarshaller INSTANCE = new StringJsonUnmarshaller();

        public static StringJsonUnmarshaller getInstance() {
            return INSTANCE;
        }

        @Override
        public String unmarshall(JsonUnmarshallerContext unmarshallerContext) throws Exception {
            return unmarshallerContext.readText();
        }
    }
}

