/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.runtime.transform;

import software.amazon.awssdk.Request;
import software.amazon.awssdk.annotation.SdkProtectedApi;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.sync.RequestBody;
import software.amazon.awssdk.utils.Validate;

@SdkProtectedApi
public class StreamingRequestMarshaller<T>
implements Marshaller<Request<T>, T> {
    private final Marshaller<Request<T>, T> delegate;
    private final RequestBody requestBody;

    public StreamingRequestMarshaller(Marshaller<Request<T>, T> delegate, RequestBody requestBody) {
        this.delegate = Validate.paramNotNull(delegate, "delegate");
        this.requestBody = Validate.paramNotNull(requestBody, "requestBody");
    }

    @Override
    public Request<T> marshall(T in) {
        Request<T> marshalled = this.delegate.marshall(in);
        marshalled.setContent(this.requestBody.asStream());
        marshalled.addHeader("Content-Length", String.valueOf(this.requestBody.getContentLength()));
        return marshalled;
    }
}

