/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.runtime.transform;

import software.amazon.awssdk.http.AbortableInputStream;
import software.amazon.awssdk.http.HttpResponse;
import software.amazon.awssdk.http.HttpResponseHandler;
import software.amazon.awssdk.sync.StreamingResponseHandler;
import software.amazon.awssdk.utils.FunctionalUtils;

public class UnmarshallingStreamingResponseHandler<ResponseT, ReturnT>
implements HttpResponseHandler<ReturnT> {
    private final FunctionalUtils.UnsafeFunction<HttpResponse, ResponseT> unmarshaller;
    private final StreamingResponseHandler<ResponseT, ReturnT> streamHandler;

    public UnmarshallingStreamingResponseHandler(StreamingResponseHandler<ResponseT, ReturnT> streamHandler, FunctionalUtils.UnsafeFunction<HttpResponse, ResponseT> unmarshaller) {
        this.unmarshaller = unmarshaller;
        this.streamHandler = streamHandler;
    }

    @Override
    public ReturnT handle(HttpResponse response) throws Exception {
        ResponseT unmarshalled = this.unmarshaller.apply(response);
        ReturnT toReturn = this.streamHandler.apply(unmarshalled, new AbortableInputStream(response.getContent(), response));
        response.getContent().close();
        return toReturn;
    }

    @Override
    public boolean needsConnectionLeftOpen() {
        return false;
    }
}

