/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild;

import software.amazon.awssdk.SdkBaseException;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.codebuild.CodeBuildClientBuilder;
import software.amazon.awssdk.services.codebuild.DefaultCodeBuildClientBuilder;
import software.amazon.awssdk.services.codebuild.model.AccountLimitExceededException;
import software.amazon.awssdk.services.codebuild.model.BatchGetBuildsRequest;
import software.amazon.awssdk.services.codebuild.model.BatchGetBuildsResponse;
import software.amazon.awssdk.services.codebuild.model.BatchGetProjectsRequest;
import software.amazon.awssdk.services.codebuild.model.BatchGetProjectsResponse;
import software.amazon.awssdk.services.codebuild.model.CodeBuildException;
import software.amazon.awssdk.services.codebuild.model.CreateProjectRequest;
import software.amazon.awssdk.services.codebuild.model.CreateProjectResponse;
import software.amazon.awssdk.services.codebuild.model.DeleteProjectRequest;
import software.amazon.awssdk.services.codebuild.model.DeleteProjectResponse;
import software.amazon.awssdk.services.codebuild.model.InvalidInputException;
import software.amazon.awssdk.services.codebuild.model.ListBuildsForProjectRequest;
import software.amazon.awssdk.services.codebuild.model.ListBuildsForProjectResponse;
import software.amazon.awssdk.services.codebuild.model.ListBuildsRequest;
import software.amazon.awssdk.services.codebuild.model.ListBuildsResponse;
import software.amazon.awssdk.services.codebuild.model.ListCuratedEnvironmentImagesRequest;
import software.amazon.awssdk.services.codebuild.model.ListCuratedEnvironmentImagesResponse;
import software.amazon.awssdk.services.codebuild.model.ListProjectsRequest;
import software.amazon.awssdk.services.codebuild.model.ListProjectsResponse;
import software.amazon.awssdk.services.codebuild.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.codebuild.model.ResourceNotFoundException;
import software.amazon.awssdk.services.codebuild.model.StartBuildRequest;
import software.amazon.awssdk.services.codebuild.model.StartBuildResponse;
import software.amazon.awssdk.services.codebuild.model.StopBuildRequest;
import software.amazon.awssdk.services.codebuild.model.StopBuildResponse;
import software.amazon.awssdk.services.codebuild.model.UpdateProjectRequest;
import software.amazon.awssdk.services.codebuild.model.UpdateProjectResponse;

public interface CodeBuildClient
extends AutoCloseable {
    public static final String SERVICE_NAME = "codebuild";

    public static CodeBuildClient create() {
        return (CodeBuildClient)CodeBuildClient.builder().build();
    }

    public static CodeBuildClientBuilder builder() {
        return new DefaultCodeBuildClientBuilder();
    }

    default public BatchGetBuildsResponse batchGetBuilds(BatchGetBuildsRequest batchGetBuildsRequest) throws InvalidInputException, SdkBaseException, SdkClientException, CodeBuildException {
        throw new UnsupportedOperationException();
    }

    default public BatchGetProjectsResponse batchGetProjects(BatchGetProjectsRequest batchGetProjectsRequest) throws InvalidInputException, SdkBaseException, SdkClientException, CodeBuildException {
        throw new UnsupportedOperationException();
    }

    default public CreateProjectResponse createProject(CreateProjectRequest createProjectRequest) throws InvalidInputException, ResourceAlreadyExistsException, AccountLimitExceededException, SdkBaseException, SdkClientException, CodeBuildException {
        throw new UnsupportedOperationException();
    }

    default public DeleteProjectResponse deleteProject(DeleteProjectRequest deleteProjectRequest) throws InvalidInputException, SdkBaseException, SdkClientException, CodeBuildException {
        throw new UnsupportedOperationException();
    }

    default public ListBuildsResponse listBuilds(ListBuildsRequest listBuildsRequest) throws InvalidInputException, SdkBaseException, SdkClientException, CodeBuildException {
        throw new UnsupportedOperationException();
    }

    default public ListBuildsForProjectResponse listBuildsForProject(ListBuildsForProjectRequest listBuildsForProjectRequest) throws InvalidInputException, ResourceNotFoundException, SdkBaseException, SdkClientException, CodeBuildException {
        throw new UnsupportedOperationException();
    }

    default public ListCuratedEnvironmentImagesResponse listCuratedEnvironmentImages(ListCuratedEnvironmentImagesRequest listCuratedEnvironmentImagesRequest) throws SdkBaseException, SdkClientException, CodeBuildException {
        throw new UnsupportedOperationException();
    }

    default public ListProjectsResponse listProjects(ListProjectsRequest listProjectsRequest) throws InvalidInputException, SdkBaseException, SdkClientException, CodeBuildException {
        throw new UnsupportedOperationException();
    }

    default public StartBuildResponse startBuild(StartBuildRequest startBuildRequest) throws InvalidInputException, ResourceNotFoundException, AccountLimitExceededException, SdkBaseException, SdkClientException, CodeBuildException {
        throw new UnsupportedOperationException();
    }

    default public StopBuildResponse stopBuild(StopBuildRequest stopBuildRequest) throws InvalidInputException, ResourceNotFoundException, SdkBaseException, SdkClientException, CodeBuildException {
        throw new UnsupportedOperationException();
    }

    default public UpdateProjectResponse updateProject(UpdateProjectRequest updateProjectRequest) throws InvalidInputException, ResourceNotFoundException, SdkBaseException, SdkClientException, CodeBuildException {
        throw new UnsupportedOperationException();
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_NAME);
    }
}

