/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.codebuild.model.BuildIdsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchGetBuildsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, BatchGetBuildsRequest> {
    private final List<String> ids;

    private BatchGetBuildsRequest(BuilderImpl builder) {
        this.ids = builder.ids;
    }

    public List<String> ids() {
        return this.ids;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.ids() == null ? 0 : this.ids().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetBuildsRequest)) {
            return false;
        }
        BatchGetBuildsRequest other = (BatchGetBuildsRequest)obj;
        if (other.ids() == null ^ this.ids() == null) {
            return false;
        }
        return other.ids() == null || other.ids().equals(this.ids());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.ids() != null) {
            sb.append("Ids: ").append(this.ids()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> ids;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetBuildsRequest model) {
            this.setIds(model.ids);
        }

        public final Collection<String> getIds() {
            return this.ids;
        }

        @Override
        public final Builder ids(Collection<String> ids) {
            this.ids = BuildIdsCopier.copy(ids);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ids(String ... ids) {
            if (this.ids == null) {
                this.ids = new ArrayList<String>(ids.length);
            }
            for (String e : ids) {
                this.ids.add(e);
            }
            return this;
        }

        public final void setIds(Collection<String> ids) {
            this.ids = BuildIdsCopier.copy(ids);
        }

        @SafeVarargs
        public final void setIds(String ... ids) {
            if (this.ids == null) {
                this.ids = new ArrayList<String>(ids.length);
            }
            for (String e : ids) {
                this.ids.add(e);
            }
        }

        @Override
        public BatchGetBuildsRequest build() {
            return new BatchGetBuildsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BatchGetBuildsRequest> {
        public Builder ids(Collection<String> var1);

        public Builder ids(String ... var1);
    }
}

