/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.codebuild.model.Project;
import software.amazon.awssdk.services.codebuild.model.ProjectNamesCopier;
import software.amazon.awssdk.services.codebuild.model.ProjectsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchGetProjectsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, BatchGetProjectsResponse> {
    private final List<Project> projects;
    private final List<String> projectsNotFound;

    private BatchGetProjectsResponse(BuilderImpl builder) {
        this.projects = builder.projects;
        this.projectsNotFound = builder.projectsNotFound;
    }

    public List<Project> projects() {
        return this.projects;
    }

    public List<String> projectsNotFound() {
        return this.projectsNotFound;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.projects() == null ? 0 : this.projects().hashCode());
        hashCode = 31 * hashCode + (this.projectsNotFound() == null ? 0 : this.projectsNotFound().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetProjectsResponse)) {
            return false;
        }
        BatchGetProjectsResponse other = (BatchGetProjectsResponse)obj;
        if (other.projects() == null ^ this.projects() == null) {
            return false;
        }
        if (other.projects() != null && !other.projects().equals(this.projects())) {
            return false;
        }
        if (other.projectsNotFound() == null ^ this.projectsNotFound() == null) {
            return false;
        }
        return other.projectsNotFound() == null || other.projectsNotFound().equals(this.projectsNotFound());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.projects() != null) {
            sb.append("Projects: ").append(this.projects()).append(",");
        }
        if (this.projectsNotFound() != null) {
            sb.append("ProjectsNotFound: ").append(this.projectsNotFound()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Project> projects;
        private List<String> projectsNotFound;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetProjectsResponse model) {
            this.setProjects(model.projects);
            this.setProjectsNotFound(model.projectsNotFound);
        }

        public final Collection<Project> getProjects() {
            return this.projects;
        }

        @Override
        public final Builder projects(Collection<Project> projects) {
            this.projects = ProjectsCopier.copy(projects);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projects(Project ... projects) {
            if (this.projects == null) {
                this.projects = new ArrayList<Project>(projects.length);
            }
            for (Project e : projects) {
                this.projects.add(e);
            }
            return this;
        }

        public final void setProjects(Collection<Project> projects) {
            this.projects = ProjectsCopier.copy(projects);
        }

        @SafeVarargs
        public final void setProjects(Project ... projects) {
            if (this.projects == null) {
                this.projects = new ArrayList<Project>(projects.length);
            }
            for (Project e : projects) {
                this.projects.add(e);
            }
        }

        public final Collection<String> getProjectsNotFound() {
            return this.projectsNotFound;
        }

        @Override
        public final Builder projectsNotFound(Collection<String> projectsNotFound) {
            this.projectsNotFound = ProjectNamesCopier.copy(projectsNotFound);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projectsNotFound(String ... projectsNotFound) {
            if (this.projectsNotFound == null) {
                this.projectsNotFound = new ArrayList<String>(projectsNotFound.length);
            }
            for (String e : projectsNotFound) {
                this.projectsNotFound.add(e);
            }
            return this;
        }

        public final void setProjectsNotFound(Collection<String> projectsNotFound) {
            this.projectsNotFound = ProjectNamesCopier.copy(projectsNotFound);
        }

        @SafeVarargs
        public final void setProjectsNotFound(String ... projectsNotFound) {
            if (this.projectsNotFound == null) {
                this.projectsNotFound = new ArrayList<String>(projectsNotFound.length);
            }
            for (String e : projectsNotFound) {
                this.projectsNotFound.add(e);
            }
        }

        @Override
        public BatchGetProjectsResponse build() {
            return new BatchGetProjectsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BatchGetProjectsResponse> {
        public Builder projects(Collection<Project> var1);

        public Builder projects(Project ... var1);

        public Builder projectsNotFound(Collection<String> var1);

        public Builder projectsNotFound(String ... var1);
    }
}

