/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.stream.Stream;
import software.amazon.awssdk.util.StringUtils;

public enum BuildPhaseType {
    SUBMITTED("SUBMITTED"),
    PROVISIONING("PROVISIONING"),
    DOWNLOAD_SOURCE("DOWNLOAD_SOURCE"),
    INSTALL("INSTALL"),
    PRE_BUILD("PRE_BUILD"),
    BUILD("BUILD"),
    POST_BUILD("POST_BUILD"),
    UPLOAD_ARTIFACTS("UPLOAD_ARTIFACTS"),
    FINALIZING("FINALIZING"),
    COMPLETED("COMPLETED");

    private final String value;

    private BuildPhaseType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    public static BuildPhaseType fromValue(String value) {
        if (StringUtils.isNullOrEmpty(value)) {
            throw new IllegalArgumentException("Value cannot be null or empty!");
        }
        return Stream.of(BuildPhaseType.values()).filter(e -> e.toString().equals(value)).findFirst().orElseThrow(() -> new IllegalArgumentException("Cannot create enum from " + value + " value!"));
    }
}

