/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.codebuild.model.EnvironmentLanguage;
import software.amazon.awssdk.services.codebuild.model.EnvironmentLanguagesCopier;
import software.amazon.awssdk.services.codebuild.model.PlatformType;
import software.amazon.awssdk.services.codebuild.transform.EnvironmentPlatformMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EnvironmentPlatform
implements StructuredPojo,
ToCopyableBuilder<Builder, EnvironmentPlatform> {
    private final String platform;
    private final List<EnvironmentLanguage> languages;

    private EnvironmentPlatform(BuilderImpl builder) {
        this.platform = builder.platform;
        this.languages = builder.languages;
    }

    public String platform() {
        return this.platform;
    }

    public List<EnvironmentLanguage> languages() {
        return this.languages;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.platform() == null ? 0 : this.platform().hashCode());
        hashCode = 31 * hashCode + (this.languages() == null ? 0 : this.languages().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentPlatform)) {
            return false;
        }
        EnvironmentPlatform other = (EnvironmentPlatform)obj;
        if (other.platform() == null ^ this.platform() == null) {
            return false;
        }
        if (other.platform() != null && !other.platform().equals(this.platform())) {
            return false;
        }
        if (other.languages() == null ^ this.languages() == null) {
            return false;
        }
        return other.languages() == null || other.languages().equals(this.languages());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.platform() != null) {
            sb.append("Platform: ").append(this.platform()).append(",");
        }
        if (this.languages() != null) {
            sb.append("Languages: ").append(this.languages()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EnvironmentPlatformMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String platform;
        private List<EnvironmentLanguage> languages;

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentPlatform model) {
            this.setPlatform(model.platform);
            this.setLanguages(model.languages);
        }

        public final String getPlatform() {
            return this.platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(PlatformType platform) {
            this.platform(platform.toString());
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final void setPlatform(PlatformType platform) {
            this.platform(platform.toString());
        }

        public final Collection<EnvironmentLanguage> getLanguages() {
            return this.languages;
        }

        @Override
        public final Builder languages(Collection<EnvironmentLanguage> languages) {
            this.languages = EnvironmentLanguagesCopier.copy(languages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder languages(EnvironmentLanguage ... languages) {
            if (this.languages == null) {
                this.languages = new ArrayList<EnvironmentLanguage>(languages.length);
            }
            for (EnvironmentLanguage e : languages) {
                this.languages.add(e);
            }
            return this;
        }

        public final void setLanguages(Collection<EnvironmentLanguage> languages) {
            this.languages = EnvironmentLanguagesCopier.copy(languages);
        }

        @SafeVarargs
        public final void setLanguages(EnvironmentLanguage ... languages) {
            if (this.languages == null) {
                this.languages = new ArrayList<EnvironmentLanguage>(languages.length);
            }
            for (EnvironmentLanguage e : languages) {
                this.languages.add(e);
            }
        }

        @Override
        public EnvironmentPlatform build() {
            return new EnvironmentPlatform(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EnvironmentPlatform> {
        public Builder platform(String var1);

        public Builder platform(PlatformType var1);

        public Builder languages(Collection<EnvironmentLanguage> var1);

        public Builder languages(EnvironmentLanguage ... var1);
    }
}

