/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.stream.Stream;
import software.amazon.awssdk.util.StringUtils;

public enum PlatformType {
    DEBIAN("DEBIAN"),
    AMAZON_LINUX("AMAZON_LINUX"),
    UBUNTU("UBUNTU");

    private final String value;

    private PlatformType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    public static PlatformType fromValue(String value) {
        if (StringUtils.isNullOrEmpty(value)) {
            throw new IllegalArgumentException("Value cannot be null or empty!");
        }
        return Stream.of(PlatformType.values()).filter(e -> e.toString().equals(value)).findFirst().orElseThrow(() -> new IllegalArgumentException("Cannot create enum from " + value + " value!"));
    }
}

