/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codebuild.model.BuildArtifacts;

@SdkInternalApi
public class BuildArtifactsMarshaller {
    private static final MarshallingInfo<String> LOCATION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("location").build();
    private static final MarshallingInfo<String> SHA256SUM_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sha256sum").build();
    private static final MarshallingInfo<String> MD5SUM_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("md5sum").build();
    private static final BuildArtifactsMarshaller instance = new BuildArtifactsMarshaller();

    public static BuildArtifactsMarshaller getInstance() {
        return instance;
    }

    public void marshall(BuildArtifacts buildArtifacts, ProtocolMarshaller protocolMarshaller) {
        if (buildArtifacts == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(buildArtifacts.location(), LOCATION_BINDING);
            protocolMarshaller.marshall(buildArtifacts.sha256sum(), SHA256SUM_BINDING);
            protocolMarshaller.marshall(buildArtifacts.md5sum(), MD5SUM_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

