/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.transform;

import java.util.Date;
import java.util.List;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codebuild.model.BuildPhase;

@SdkInternalApi
public class BuildPhaseMarshaller {
    private static final MarshallingInfo<String> PHASETYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("phaseType").build();
    private static final MarshallingInfo<String> PHASESTATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("phaseStatus").build();
    private static final MarshallingInfo<Date> STARTTIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("startTime").build();
    private static final MarshallingInfo<Date> ENDTIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("endTime").build();
    private static final MarshallingInfo<Long> DURATIONINSECONDS_BINDING = MarshallingInfo.builder(MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("durationInSeconds").build();
    private static final MarshallingInfo<List> CONTEXTS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("contexts").build();
    private static final BuildPhaseMarshaller instance = new BuildPhaseMarshaller();

    public static BuildPhaseMarshaller getInstance() {
        return instance;
    }

    public void marshall(BuildPhase buildPhase, ProtocolMarshaller protocolMarshaller) {
        if (buildPhase == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(buildPhase.phaseType(), PHASETYPE_BINDING);
            protocolMarshaller.marshall(buildPhase.phaseStatus(), PHASESTATUS_BINDING);
            protocolMarshaller.marshall(buildPhase.startTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall(buildPhase.endTime(), ENDTIME_BINDING);
            protocolMarshaller.marshall(buildPhase.durationInSeconds(), DURATIONINSECONDS_BINDING);
            protocolMarshaller.marshall(buildPhase.contexts(), CONTEXTS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

