/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.util.Date;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.codebuild.model.Build;
import software.amazon.awssdk.services.codebuild.model.BuildPhase;
import software.amazon.awssdk.services.codebuild.transform.BuildArtifactsUnmarshaller;
import software.amazon.awssdk.services.codebuild.transform.BuildPhaseUnmarshaller;
import software.amazon.awssdk.services.codebuild.transform.LogsLocationUnmarshaller;
import software.amazon.awssdk.services.codebuild.transform.ProjectEnvironmentUnmarshaller;
import software.amazon.awssdk.services.codebuild.transform.ProjectSourceUnmarshaller;

public class BuildUnmarshaller
implements Unmarshaller<Build, JsonUnmarshallerContext> {
    private static BuildUnmarshaller INSTANCE;

    @Override
    public Build unmarshall(JsonUnmarshallerContext context) throws Exception {
        Build.Builder buildBuilder = Build.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("id", targetDepth)) {
                    context.nextToken();
                    buildBuilder.id(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("arn", targetDepth)) {
                    context.nextToken();
                    buildBuilder.arn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("startTime", targetDepth)) {
                    context.nextToken();
                    buildBuilder.startTime(context.getUnmarshaller(Date.class).unmarshall(context));
                }
                if (context.testExpression("endTime", targetDepth)) {
                    context.nextToken();
                    buildBuilder.endTime(context.getUnmarshaller(Date.class).unmarshall(context));
                }
                if (context.testExpression("currentPhase", targetDepth)) {
                    context.nextToken();
                    buildBuilder.currentPhase(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("buildStatus", targetDepth)) {
                    context.nextToken();
                    buildBuilder.buildStatus(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("sourceVersion", targetDepth)) {
                    context.nextToken();
                    buildBuilder.sourceVersion(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("projectName", targetDepth)) {
                    context.nextToken();
                    buildBuilder.projectName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("phases", targetDepth)) {
                    context.nextToken();
                    buildBuilder.phases(new ListUnmarshaller<BuildPhase>(BuildPhaseUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("source", targetDepth)) {
                    context.nextToken();
                    buildBuilder.source(ProjectSourceUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("artifacts", targetDepth)) {
                    context.nextToken();
                    buildBuilder.artifacts(BuildArtifactsUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("environment", targetDepth)) {
                    context.nextToken();
                    buildBuilder.environment(ProjectEnvironmentUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("logs", targetDepth)) {
                    context.nextToken();
                    buildBuilder.logs(LogsLocationUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("timeoutInMinutes", targetDepth)) {
                    context.nextToken();
                    buildBuilder.timeoutInMinutes(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("buildComplete", targetDepth)) {
                    context.nextToken();
                    buildBuilder.buildComplete(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("initiator", targetDepth)) {
                    context.nextToken();
                    buildBuilder.initiator(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Build)buildBuilder.build();
    }

    public static BuildUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new BuildUnmarshaller();
        }
        return INSTANCE;
    }
}

