/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.transform;

import java.util.List;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codebuild.model.EnvironmentPlatform;

@SdkInternalApi
public class EnvironmentPlatformMarshaller {
    private static final MarshallingInfo<String> PLATFORM_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("platform").build();
    private static final MarshallingInfo<List> LANGUAGES_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("languages").build();
    private static final EnvironmentPlatformMarshaller instance = new EnvironmentPlatformMarshaller();

    public static EnvironmentPlatformMarshaller getInstance() {
        return instance;
    }

    public void marshall(EnvironmentPlatform environmentPlatform, ProtocolMarshaller protocolMarshaller) {
        if (environmentPlatform == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(environmentPlatform.platform(), PLATFORM_BINDING);
            protocolMarshaller.marshall(environmentPlatform.languages(), LANGUAGES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

