/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline;

import software.amazon.awssdk.AmazonServiceException;
import software.amazon.awssdk.SdkBaseException;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.client.AwsSyncClientParams;
import software.amazon.awssdk.client.ClientExecutionParams;
import software.amazon.awssdk.client.ClientHandler;
import software.amazon.awssdk.client.ClientHandlerParams;
import software.amazon.awssdk.client.SdkClientHandler;
import software.amazon.awssdk.http.HttpResponseHandler;
import software.amazon.awssdk.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.protocol.json.SdkJsonProtocolFactory;
import software.amazon.awssdk.runtime.http.response.JsonResponseHandler;
import software.amazon.awssdk.services.codepipeline.CodePipelineClient;
import software.amazon.awssdk.services.codepipeline.model.AcknowledgeJobRequest;
import software.amazon.awssdk.services.codepipeline.model.AcknowledgeJobResponse;
import software.amazon.awssdk.services.codepipeline.model.AcknowledgeThirdPartyJobRequest;
import software.amazon.awssdk.services.codepipeline.model.AcknowledgeThirdPartyJobResponse;
import software.amazon.awssdk.services.codepipeline.model.ActionNotFoundException;
import software.amazon.awssdk.services.codepipeline.model.ActionTypeNotFoundException;
import software.amazon.awssdk.services.codepipeline.model.ApprovalAlreadyCompletedException;
import software.amazon.awssdk.services.codepipeline.model.CodePipelineException;
import software.amazon.awssdk.services.codepipeline.model.CreateCustomActionTypeRequest;
import software.amazon.awssdk.services.codepipeline.model.CreateCustomActionTypeResponse;
import software.amazon.awssdk.services.codepipeline.model.CreatePipelineRequest;
import software.amazon.awssdk.services.codepipeline.model.CreatePipelineResponse;
import software.amazon.awssdk.services.codepipeline.model.DeleteCustomActionTypeRequest;
import software.amazon.awssdk.services.codepipeline.model.DeleteCustomActionTypeResponse;
import software.amazon.awssdk.services.codepipeline.model.DeletePipelineRequest;
import software.amazon.awssdk.services.codepipeline.model.DeletePipelineResponse;
import software.amazon.awssdk.services.codepipeline.model.DisableStageTransitionRequest;
import software.amazon.awssdk.services.codepipeline.model.DisableStageTransitionResponse;
import software.amazon.awssdk.services.codepipeline.model.EnableStageTransitionRequest;
import software.amazon.awssdk.services.codepipeline.model.EnableStageTransitionResponse;
import software.amazon.awssdk.services.codepipeline.model.GetJobDetailsRequest;
import software.amazon.awssdk.services.codepipeline.model.GetJobDetailsResponse;
import software.amazon.awssdk.services.codepipeline.model.GetPipelineExecutionRequest;
import software.amazon.awssdk.services.codepipeline.model.GetPipelineExecutionResponse;
import software.amazon.awssdk.services.codepipeline.model.GetPipelineRequest;
import software.amazon.awssdk.services.codepipeline.model.GetPipelineResponse;
import software.amazon.awssdk.services.codepipeline.model.GetPipelineStateRequest;
import software.amazon.awssdk.services.codepipeline.model.GetPipelineStateResponse;
import software.amazon.awssdk.services.codepipeline.model.GetThirdPartyJobDetailsRequest;
import software.amazon.awssdk.services.codepipeline.model.GetThirdPartyJobDetailsResponse;
import software.amazon.awssdk.services.codepipeline.model.InvalidActionDeclarationException;
import software.amazon.awssdk.services.codepipeline.model.InvalidApprovalTokenException;
import software.amazon.awssdk.services.codepipeline.model.InvalidBlockerDeclarationException;
import software.amazon.awssdk.services.codepipeline.model.InvalidClientTokenException;
import software.amazon.awssdk.services.codepipeline.model.InvalidJobException;
import software.amazon.awssdk.services.codepipeline.model.InvalidJobStateException;
import software.amazon.awssdk.services.codepipeline.model.InvalidNextTokenException;
import software.amazon.awssdk.services.codepipeline.model.InvalidNonceException;
import software.amazon.awssdk.services.codepipeline.model.InvalidStageDeclarationException;
import software.amazon.awssdk.services.codepipeline.model.InvalidStructureException;
import software.amazon.awssdk.services.codepipeline.model.JobNotFoundException;
import software.amazon.awssdk.services.codepipeline.model.LimitExceededException;
import software.amazon.awssdk.services.codepipeline.model.ListActionTypesRequest;
import software.amazon.awssdk.services.codepipeline.model.ListActionTypesResponse;
import software.amazon.awssdk.services.codepipeline.model.ListPipelineExecutionsRequest;
import software.amazon.awssdk.services.codepipeline.model.ListPipelineExecutionsResponse;
import software.amazon.awssdk.services.codepipeline.model.ListPipelinesRequest;
import software.amazon.awssdk.services.codepipeline.model.ListPipelinesResponse;
import software.amazon.awssdk.services.codepipeline.model.NotLatestPipelineExecutionException;
import software.amazon.awssdk.services.codepipeline.model.PipelineExecutionNotFoundException;
import software.amazon.awssdk.services.codepipeline.model.PipelineNameInUseException;
import software.amazon.awssdk.services.codepipeline.model.PipelineNotFoundException;
import software.amazon.awssdk.services.codepipeline.model.PipelineVersionNotFoundException;
import software.amazon.awssdk.services.codepipeline.model.PollForJobsRequest;
import software.amazon.awssdk.services.codepipeline.model.PollForJobsResponse;
import software.amazon.awssdk.services.codepipeline.model.PollForThirdPartyJobsRequest;
import software.amazon.awssdk.services.codepipeline.model.PollForThirdPartyJobsResponse;
import software.amazon.awssdk.services.codepipeline.model.PutActionRevisionRequest;
import software.amazon.awssdk.services.codepipeline.model.PutActionRevisionResponse;
import software.amazon.awssdk.services.codepipeline.model.PutApprovalResultRequest;
import software.amazon.awssdk.services.codepipeline.model.PutApprovalResultResponse;
import software.amazon.awssdk.services.codepipeline.model.PutJobFailureResultRequest;
import software.amazon.awssdk.services.codepipeline.model.PutJobFailureResultResponse;
import software.amazon.awssdk.services.codepipeline.model.PutJobSuccessResultRequest;
import software.amazon.awssdk.services.codepipeline.model.PutJobSuccessResultResponse;
import software.amazon.awssdk.services.codepipeline.model.PutThirdPartyJobFailureResultRequest;
import software.amazon.awssdk.services.codepipeline.model.PutThirdPartyJobFailureResultResponse;
import software.amazon.awssdk.services.codepipeline.model.PutThirdPartyJobSuccessResultRequest;
import software.amazon.awssdk.services.codepipeline.model.PutThirdPartyJobSuccessResultResponse;
import software.amazon.awssdk.services.codepipeline.model.RetryStageExecutionRequest;
import software.amazon.awssdk.services.codepipeline.model.RetryStageExecutionResponse;
import software.amazon.awssdk.services.codepipeline.model.StageNotFoundException;
import software.amazon.awssdk.services.codepipeline.model.StageNotRetryableException;
import software.amazon.awssdk.services.codepipeline.model.StartPipelineExecutionRequest;
import software.amazon.awssdk.services.codepipeline.model.StartPipelineExecutionResponse;
import software.amazon.awssdk.services.codepipeline.model.UpdatePipelineRequest;
import software.amazon.awssdk.services.codepipeline.model.UpdatePipelineResponse;
import software.amazon.awssdk.services.codepipeline.model.ValidationException;
import software.amazon.awssdk.services.codepipeline.transform.AcknowledgeJobRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.AcknowledgeJobResponseUnmarshaller;
import software.amazon.awssdk.services.codepipeline.transform.AcknowledgeThirdPartyJobRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.AcknowledgeThirdPartyJobResponseUnmarshaller;
import software.amazon.awssdk.services.codepipeline.transform.CreateCustomActionTypeRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.CreateCustomActionTypeResponseUnmarshaller;
import software.amazon.awssdk.services.codepipeline.transform.CreatePipelineRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.CreatePipelineResponseUnmarshaller;
import software.amazon.awssdk.services.codepipeline.transform.DeleteCustomActionTypeRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.DeleteCustomActionTypeResponseUnmarshaller;
import software.amazon.awssdk.services.codepipeline.transform.DeletePipelineRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.DeletePipelineResponseUnmarshaller;
import software.amazon.awssdk.services.codepipeline.transform.DisableStageTransitionRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.DisableStageTransitionResponseUnmarshaller;
import software.amazon.awssdk.services.codepipeline.transform.EnableStageTransitionRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.EnableStageTransitionResponseUnmarshaller;
import software.amazon.awssdk.services.codepipeline.transform.GetJobDetailsRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.GetJobDetailsResponseUnmarshaller;
import software.amazon.awssdk.services.codepipeline.transform.GetPipelineExecutionRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.GetPipelineExecutionResponseUnmarshaller;
import software.amazon.awssdk.services.codepipeline.transform.GetPipelineRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.GetPipelineResponseUnmarshaller;
import software.amazon.awssdk.services.codepipeline.transform.GetPipelineStateRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.GetPipelineStateResponseUnmarshaller;
import software.amazon.awssdk.services.codepipeline.transform.GetThirdPartyJobDetailsRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.GetThirdPartyJobDetailsResponseUnmarshaller;
import software.amazon.awssdk.services.codepipeline.transform.ListActionTypesRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.ListActionTypesResponseUnmarshaller;
import software.amazon.awssdk.services.codepipeline.transform.ListPipelineExecutionsRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.ListPipelineExecutionsResponseUnmarshaller;
import software.amazon.awssdk.services.codepipeline.transform.ListPipelinesRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.ListPipelinesResponseUnmarshaller;
import software.amazon.awssdk.services.codepipeline.transform.PollForJobsRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.PollForJobsResponseUnmarshaller;
import software.amazon.awssdk.services.codepipeline.transform.PollForThirdPartyJobsRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.PollForThirdPartyJobsResponseUnmarshaller;
import software.amazon.awssdk.services.codepipeline.transform.PutActionRevisionRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.PutActionRevisionResponseUnmarshaller;
import software.amazon.awssdk.services.codepipeline.transform.PutApprovalResultRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.PutApprovalResultResponseUnmarshaller;
import software.amazon.awssdk.services.codepipeline.transform.PutJobFailureResultRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.PutJobFailureResultResponseUnmarshaller;
import software.amazon.awssdk.services.codepipeline.transform.PutJobSuccessResultRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.PutJobSuccessResultResponseUnmarshaller;
import software.amazon.awssdk.services.codepipeline.transform.PutThirdPartyJobFailureResultRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.PutThirdPartyJobFailureResultResponseUnmarshaller;
import software.amazon.awssdk.services.codepipeline.transform.PutThirdPartyJobSuccessResultRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.PutThirdPartyJobSuccessResultResponseUnmarshaller;
import software.amazon.awssdk.services.codepipeline.transform.RetryStageExecutionRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.RetryStageExecutionResponseUnmarshaller;
import software.amazon.awssdk.services.codepipeline.transform.StartPipelineExecutionRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.StartPipelineExecutionResponseUnmarshaller;
import software.amazon.awssdk.services.codepipeline.transform.UpdatePipelineRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.UpdatePipelineResponseUnmarshaller;

@SdkInternalApi
final class DefaultCodePipelineClient
implements CodePipelineClient {
    private final ClientHandler clientHandler;
    private final SdkJsonProtocolFactory protocolFactory;
    private final AwsSyncClientParams clientParams;

    protected DefaultCodePipelineClient(AwsSyncClientParams clientParams) {
        this.clientHandler = new SdkClientHandler(new ClientHandlerParams().withClientParams(clientParams).withCalculateCrc32FromCompressedDataEnabled(false));
        this.clientParams = clientParams;
        this.protocolFactory = this.init();
    }

    @Override
    public AcknowledgeJobResponse acknowledgeJob(AcknowledgeJobRequest acknowledgeJobRequest) throws ValidationException, InvalidNonceException, JobNotFoundException, SdkBaseException, SdkClientException, CodePipelineException {
        JsonResponseHandler<AcknowledgeJobResponse> responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), new AcknowledgeJobResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(acknowledgeJobRequest).withMarshaller(new AcknowledgeJobRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public AcknowledgeThirdPartyJobResponse acknowledgeThirdPartyJob(AcknowledgeThirdPartyJobRequest acknowledgeThirdPartyJobRequest) throws ValidationException, InvalidNonceException, JobNotFoundException, InvalidClientTokenException, SdkBaseException, SdkClientException, CodePipelineException {
        JsonResponseHandler<AcknowledgeThirdPartyJobResponse> responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), new AcknowledgeThirdPartyJobResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(acknowledgeThirdPartyJobRequest).withMarshaller(new AcknowledgeThirdPartyJobRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateCustomActionTypeResponse createCustomActionType(CreateCustomActionTypeRequest createCustomActionTypeRequest) throws ValidationException, LimitExceededException, SdkBaseException, SdkClientException, CodePipelineException {
        JsonResponseHandler<CreateCustomActionTypeResponse> responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), new CreateCustomActionTypeResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(createCustomActionTypeRequest).withMarshaller(new CreateCustomActionTypeRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreatePipelineResponse createPipeline(CreatePipelineRequest createPipelineRequest) throws ValidationException, PipelineNameInUseException, InvalidStageDeclarationException, InvalidActionDeclarationException, InvalidBlockerDeclarationException, InvalidStructureException, LimitExceededException, SdkBaseException, SdkClientException, CodePipelineException {
        JsonResponseHandler<CreatePipelineResponse> responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), new CreatePipelineResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(createPipelineRequest).withMarshaller(new CreatePipelineRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteCustomActionTypeResponse deleteCustomActionType(DeleteCustomActionTypeRequest deleteCustomActionTypeRequest) throws ValidationException, SdkBaseException, SdkClientException, CodePipelineException {
        JsonResponseHandler<DeleteCustomActionTypeResponse> responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), new DeleteCustomActionTypeResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(deleteCustomActionTypeRequest).withMarshaller(new DeleteCustomActionTypeRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeletePipelineResponse deletePipeline(DeletePipelineRequest deletePipelineRequest) throws ValidationException, SdkBaseException, SdkClientException, CodePipelineException {
        JsonResponseHandler<DeletePipelineResponse> responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), new DeletePipelineResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(deletePipelineRequest).withMarshaller(new DeletePipelineRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DisableStageTransitionResponse disableStageTransition(DisableStageTransitionRequest disableStageTransitionRequest) throws ValidationException, PipelineNotFoundException, StageNotFoundException, SdkBaseException, SdkClientException, CodePipelineException {
        JsonResponseHandler<DisableStageTransitionResponse> responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), new DisableStageTransitionResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(disableStageTransitionRequest).withMarshaller(new DisableStageTransitionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public EnableStageTransitionResponse enableStageTransition(EnableStageTransitionRequest enableStageTransitionRequest) throws ValidationException, PipelineNotFoundException, StageNotFoundException, SdkBaseException, SdkClientException, CodePipelineException {
        JsonResponseHandler<EnableStageTransitionResponse> responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), new EnableStageTransitionResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(enableStageTransitionRequest).withMarshaller(new EnableStageTransitionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetJobDetailsResponse getJobDetails(GetJobDetailsRequest getJobDetailsRequest) throws ValidationException, JobNotFoundException, SdkBaseException, SdkClientException, CodePipelineException {
        JsonResponseHandler<GetJobDetailsResponse> responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), new GetJobDetailsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(getJobDetailsRequest).withMarshaller(new GetJobDetailsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetPipelineResponse getPipeline(GetPipelineRequest getPipelineRequest) throws ValidationException, PipelineNotFoundException, PipelineVersionNotFoundException, SdkBaseException, SdkClientException, CodePipelineException {
        JsonResponseHandler<GetPipelineResponse> responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), new GetPipelineResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(getPipelineRequest).withMarshaller(new GetPipelineRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetPipelineExecutionResponse getPipelineExecution(GetPipelineExecutionRequest getPipelineExecutionRequest) throws ValidationException, PipelineNotFoundException, PipelineExecutionNotFoundException, SdkBaseException, SdkClientException, CodePipelineException {
        JsonResponseHandler<GetPipelineExecutionResponse> responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), new GetPipelineExecutionResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(getPipelineExecutionRequest).withMarshaller(new GetPipelineExecutionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetPipelineStateResponse getPipelineState(GetPipelineStateRequest getPipelineStateRequest) throws ValidationException, PipelineNotFoundException, SdkBaseException, SdkClientException, CodePipelineException {
        JsonResponseHandler<GetPipelineStateResponse> responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), new GetPipelineStateResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(getPipelineStateRequest).withMarshaller(new GetPipelineStateRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetThirdPartyJobDetailsResponse getThirdPartyJobDetails(GetThirdPartyJobDetailsRequest getThirdPartyJobDetailsRequest) throws JobNotFoundException, ValidationException, InvalidClientTokenException, InvalidJobException, SdkBaseException, SdkClientException, CodePipelineException {
        JsonResponseHandler<GetThirdPartyJobDetailsResponse> responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), new GetThirdPartyJobDetailsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(getThirdPartyJobDetailsRequest).withMarshaller(new GetThirdPartyJobDetailsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListActionTypesResponse listActionTypes(ListActionTypesRequest listActionTypesRequest) throws ValidationException, InvalidNextTokenException, SdkBaseException, SdkClientException, CodePipelineException {
        JsonResponseHandler<ListActionTypesResponse> responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), new ListActionTypesResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(listActionTypesRequest).withMarshaller(new ListActionTypesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListPipelineExecutionsResponse listPipelineExecutions(ListPipelineExecutionsRequest listPipelineExecutionsRequest) throws ValidationException, PipelineNotFoundException, InvalidNextTokenException, SdkBaseException, SdkClientException, CodePipelineException {
        JsonResponseHandler<ListPipelineExecutionsResponse> responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), new ListPipelineExecutionsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(listPipelineExecutionsRequest).withMarshaller(new ListPipelineExecutionsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListPipelinesResponse listPipelines(ListPipelinesRequest listPipelinesRequest) throws InvalidNextTokenException, SdkBaseException, SdkClientException, CodePipelineException {
        JsonResponseHandler<ListPipelinesResponse> responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), new ListPipelinesResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(listPipelinesRequest).withMarshaller(new ListPipelinesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public PollForJobsResponse pollForJobs(PollForJobsRequest pollForJobsRequest) throws ValidationException, ActionTypeNotFoundException, SdkBaseException, SdkClientException, CodePipelineException {
        JsonResponseHandler<PollForJobsResponse> responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), new PollForJobsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(pollForJobsRequest).withMarshaller(new PollForJobsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public PollForThirdPartyJobsResponse pollForThirdPartyJobs(PollForThirdPartyJobsRequest pollForThirdPartyJobsRequest) throws ActionTypeNotFoundException, ValidationException, SdkBaseException, SdkClientException, CodePipelineException {
        JsonResponseHandler<PollForThirdPartyJobsResponse> responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), new PollForThirdPartyJobsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(pollForThirdPartyJobsRequest).withMarshaller(new PollForThirdPartyJobsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public PutActionRevisionResponse putActionRevision(PutActionRevisionRequest putActionRevisionRequest) throws PipelineNotFoundException, StageNotFoundException, ActionNotFoundException, ValidationException, SdkBaseException, SdkClientException, CodePipelineException {
        JsonResponseHandler<PutActionRevisionResponse> responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), new PutActionRevisionResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(putActionRevisionRequest).withMarshaller(new PutActionRevisionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public PutApprovalResultResponse putApprovalResult(PutApprovalResultRequest putApprovalResultRequest) throws InvalidApprovalTokenException, ApprovalAlreadyCompletedException, PipelineNotFoundException, StageNotFoundException, ActionNotFoundException, ValidationException, SdkBaseException, SdkClientException, CodePipelineException {
        JsonResponseHandler<PutApprovalResultResponse> responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), new PutApprovalResultResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(putApprovalResultRequest).withMarshaller(new PutApprovalResultRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public PutJobFailureResultResponse putJobFailureResult(PutJobFailureResultRequest putJobFailureResultRequest) throws ValidationException, JobNotFoundException, InvalidJobStateException, SdkBaseException, SdkClientException, CodePipelineException {
        JsonResponseHandler<PutJobFailureResultResponse> responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), new PutJobFailureResultResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(putJobFailureResultRequest).withMarshaller(new PutJobFailureResultRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public PutJobSuccessResultResponse putJobSuccessResult(PutJobSuccessResultRequest putJobSuccessResultRequest) throws ValidationException, JobNotFoundException, InvalidJobStateException, SdkBaseException, SdkClientException, CodePipelineException {
        JsonResponseHandler<PutJobSuccessResultResponse> responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), new PutJobSuccessResultResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(putJobSuccessResultRequest).withMarshaller(new PutJobSuccessResultRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public PutThirdPartyJobFailureResultResponse putThirdPartyJobFailureResult(PutThirdPartyJobFailureResultRequest putThirdPartyJobFailureResultRequest) throws ValidationException, JobNotFoundException, InvalidJobStateException, InvalidClientTokenException, SdkBaseException, SdkClientException, CodePipelineException {
        JsonResponseHandler<PutThirdPartyJobFailureResultResponse> responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), new PutThirdPartyJobFailureResultResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(putThirdPartyJobFailureResultRequest).withMarshaller(new PutThirdPartyJobFailureResultRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public PutThirdPartyJobSuccessResultResponse putThirdPartyJobSuccessResult(PutThirdPartyJobSuccessResultRequest putThirdPartyJobSuccessResultRequest) throws ValidationException, JobNotFoundException, InvalidJobStateException, InvalidClientTokenException, SdkBaseException, SdkClientException, CodePipelineException {
        JsonResponseHandler<PutThirdPartyJobSuccessResultResponse> responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), new PutThirdPartyJobSuccessResultResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(putThirdPartyJobSuccessResultRequest).withMarshaller(new PutThirdPartyJobSuccessResultRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public RetryStageExecutionResponse retryStageExecution(RetryStageExecutionRequest retryStageExecutionRequest) throws ValidationException, PipelineNotFoundException, StageNotFoundException, StageNotRetryableException, NotLatestPipelineExecutionException, SdkBaseException, SdkClientException, CodePipelineException {
        JsonResponseHandler<RetryStageExecutionResponse> responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), new RetryStageExecutionResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(retryStageExecutionRequest).withMarshaller(new RetryStageExecutionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public StartPipelineExecutionResponse startPipelineExecution(StartPipelineExecutionRequest startPipelineExecutionRequest) throws ValidationException, PipelineNotFoundException, SdkBaseException, SdkClientException, CodePipelineException {
        JsonResponseHandler<StartPipelineExecutionResponse> responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), new StartPipelineExecutionResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(startPipelineExecutionRequest).withMarshaller(new StartPipelineExecutionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdatePipelineResponse updatePipeline(UpdatePipelineRequest updatePipelineRequest) throws ValidationException, InvalidStageDeclarationException, InvalidActionDeclarationException, InvalidBlockerDeclarationException, InvalidStructureException, SdkBaseException, SdkClientException, CodePipelineException {
        JsonResponseHandler<UpdatePipelineResponse> responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), new UpdatePipelineResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(updatePipelineRequest).withMarshaller(new UpdatePipelineRequestMarshaller(this.protocolFactory)));
    }

    private HttpResponseHandler<AmazonServiceException> createErrorResponseHandler() {
        return this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }

    private SdkJsonProtocolFactory init() {
        return new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withBaseServiceExceptionClass(CodePipelineException.class).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidClientTokenException").withModeledClass(InvalidClientTokenException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidJobStateException").withModeledClass(InvalidJobStateException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("PipelineVersionNotFoundException").withModeledClass(PipelineVersionNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidApprovalTokenException").withModeledClass(InvalidApprovalTokenException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidActionDeclarationException").withModeledClass(InvalidActionDeclarationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("PipelineExecutionNotFoundException").withModeledClass(PipelineExecutionNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ApprovalAlreadyCompletedException").withModeledClass(ApprovalAlreadyCompletedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("PipelineNameInUseException").withModeledClass(PipelineNameInUseException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("PipelineNotFoundException").withModeledClass(PipelineNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidNextTokenException").withModeledClass(InvalidNextTokenException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidJobException").withModeledClass(InvalidJobException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withModeledClass(LimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ActionTypeNotFoundException").withModeledClass(ActionTypeNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("StageNotFoundException").withModeledClass(StageNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("StageNotRetryableException").withModeledClass(StageNotRetryableException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidStructureException").withModeledClass(InvalidStructureException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidBlockerDeclarationException").withModeledClass(InvalidBlockerDeclarationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ActionNotFoundException").withModeledClass(ActionNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidStageDeclarationException").withModeledClass(InvalidStageDeclarationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withModeledClass(ValidationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidNonceException").withModeledClass(InvalidNonceException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("JobNotFoundException").withModeledClass(JobNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NotLatestPipelineExecutionException").withModeledClass(NotLatestPipelineExecutionException.class)));
    }

    @Override
    public void close() throws Exception {
        this.clientHandler.close();
    }
}

