/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AcknowledgeJobRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, AcknowledgeJobRequest> {
    private final String jobId;
    private final String nonce;

    private AcknowledgeJobRequest(BuilderImpl builder) {
        this.jobId = builder.jobId;
        this.nonce = builder.nonce;
    }

    public String jobId() {
        return this.jobId;
    }

    public String nonce() {
        return this.nonce;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.jobId() == null ? 0 : this.jobId().hashCode());
        hashCode = 31 * hashCode + (this.nonce() == null ? 0 : this.nonce().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AcknowledgeJobRequest)) {
            return false;
        }
        AcknowledgeJobRequest other = (AcknowledgeJobRequest)obj;
        if (other.jobId() == null ^ this.jobId() == null) {
            return false;
        }
        if (other.jobId() != null && !other.jobId().equals(this.jobId())) {
            return false;
        }
        if (other.nonce() == null ^ this.nonce() == null) {
            return false;
        }
        return other.nonce() == null || other.nonce().equals(this.nonce());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.jobId() != null) {
            sb.append("JobId: ").append(this.jobId()).append(",");
        }
        if (this.nonce() != null) {
            sb.append("Nonce: ").append(this.nonce()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String jobId;
        private String nonce;

        private BuilderImpl() {
        }

        private BuilderImpl(AcknowledgeJobRequest model) {
            this.setJobId(model.jobId);
            this.setNonce(model.nonce);
        }

        public final String getJobId() {
            return this.jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final String getNonce() {
            return this.nonce;
        }

        @Override
        public final Builder nonce(String nonce) {
            this.nonce = nonce;
            return this;
        }

        public final void setNonce(String nonce) {
            this.nonce = nonce;
        }

        @Override
        public AcknowledgeJobRequest build() {
            return new AcknowledgeJobRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AcknowledgeJobRequest> {
        public Builder jobId(String var1);

        public Builder nonce(String var1);
    }
}

