/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Date;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.codepipeline.transform.ActionRevisionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ActionRevision
implements StructuredPojo,
ToCopyableBuilder<Builder, ActionRevision> {
    private final String revisionId;
    private final String revisionChangeId;
    private final Date created;

    private ActionRevision(BuilderImpl builder) {
        this.revisionId = builder.revisionId;
        this.revisionChangeId = builder.revisionChangeId;
        this.created = builder.created;
    }

    public String revisionId() {
        return this.revisionId;
    }

    public String revisionChangeId() {
        return this.revisionChangeId;
    }

    public Date created() {
        return this.created;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.revisionId() == null ? 0 : this.revisionId().hashCode());
        hashCode = 31 * hashCode + (this.revisionChangeId() == null ? 0 : this.revisionChangeId().hashCode());
        hashCode = 31 * hashCode + (this.created() == null ? 0 : this.created().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionRevision)) {
            return false;
        }
        ActionRevision other = (ActionRevision)obj;
        if (other.revisionId() == null ^ this.revisionId() == null) {
            return false;
        }
        if (other.revisionId() != null && !other.revisionId().equals(this.revisionId())) {
            return false;
        }
        if (other.revisionChangeId() == null ^ this.revisionChangeId() == null) {
            return false;
        }
        if (other.revisionChangeId() != null && !other.revisionChangeId().equals(this.revisionChangeId())) {
            return false;
        }
        if (other.created() == null ^ this.created() == null) {
            return false;
        }
        return other.created() == null || other.created().equals(this.created());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.revisionId() != null) {
            sb.append("RevisionId: ").append(this.revisionId()).append(",");
        }
        if (this.revisionChangeId() != null) {
            sb.append("RevisionChangeId: ").append(this.revisionChangeId()).append(",");
        }
        if (this.created() != null) {
            sb.append("Created: ").append(this.created()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ActionRevisionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String revisionId;
        private String revisionChangeId;
        private Date created;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionRevision model) {
            this.setRevisionId(model.revisionId);
            this.setRevisionChangeId(model.revisionChangeId);
            this.setCreated(model.created);
        }

        public final String getRevisionId() {
            return this.revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        public final String getRevisionChangeId() {
            return this.revisionChangeId;
        }

        @Override
        public final Builder revisionChangeId(String revisionChangeId) {
            this.revisionChangeId = revisionChangeId;
            return this;
        }

        public final void setRevisionChangeId(String revisionChangeId) {
            this.revisionChangeId = revisionChangeId;
        }

        public final Date getCreated() {
            return this.created;
        }

        @Override
        public final Builder created(Date created) {
            this.created = StandardMemberCopier.copy(created);
            return this;
        }

        public final void setCreated(Date created) {
            this.created = StandardMemberCopier.copy(created);
        }

        @Override
        public ActionRevision build() {
            return new ActionRevision(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ActionRevision> {
        public Builder revisionId(String var1);

        public Builder revisionChangeId(String var1);

        public Builder created(Date var1);
    }
}

