/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Date;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.codepipeline.transform.ArtifactRevisionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ArtifactRevision
implements StructuredPojo,
ToCopyableBuilder<Builder, ArtifactRevision> {
    private final String name;
    private final String revisionId;
    private final String revisionChangeIdentifier;
    private final String revisionSummary;
    private final Date created;
    private final String revisionUrl;

    private ArtifactRevision(BuilderImpl builder) {
        this.name = builder.name;
        this.revisionId = builder.revisionId;
        this.revisionChangeIdentifier = builder.revisionChangeIdentifier;
        this.revisionSummary = builder.revisionSummary;
        this.created = builder.created;
        this.revisionUrl = builder.revisionUrl;
    }

    public String name() {
        return this.name;
    }

    public String revisionId() {
        return this.revisionId;
    }

    public String revisionChangeIdentifier() {
        return this.revisionChangeIdentifier;
    }

    public String revisionSummary() {
        return this.revisionSummary;
    }

    public Date created() {
        return this.created;
    }

    public String revisionUrl() {
        return this.revisionUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.revisionId() == null ? 0 : this.revisionId().hashCode());
        hashCode = 31 * hashCode + (this.revisionChangeIdentifier() == null ? 0 : this.revisionChangeIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.revisionSummary() == null ? 0 : this.revisionSummary().hashCode());
        hashCode = 31 * hashCode + (this.created() == null ? 0 : this.created().hashCode());
        hashCode = 31 * hashCode + (this.revisionUrl() == null ? 0 : this.revisionUrl().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArtifactRevision)) {
            return false;
        }
        ArtifactRevision other = (ArtifactRevision)obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.revisionId() == null ^ this.revisionId() == null) {
            return false;
        }
        if (other.revisionId() != null && !other.revisionId().equals(this.revisionId())) {
            return false;
        }
        if (other.revisionChangeIdentifier() == null ^ this.revisionChangeIdentifier() == null) {
            return false;
        }
        if (other.revisionChangeIdentifier() != null && !other.revisionChangeIdentifier().equals(this.revisionChangeIdentifier())) {
            return false;
        }
        if (other.revisionSummary() == null ^ this.revisionSummary() == null) {
            return false;
        }
        if (other.revisionSummary() != null && !other.revisionSummary().equals(this.revisionSummary())) {
            return false;
        }
        if (other.created() == null ^ this.created() == null) {
            return false;
        }
        if (other.created() != null && !other.created().equals(this.created())) {
            return false;
        }
        if (other.revisionUrl() == null ^ this.revisionUrl() == null) {
            return false;
        }
        return other.revisionUrl() == null || other.revisionUrl().equals(this.revisionUrl());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.revisionId() != null) {
            sb.append("RevisionId: ").append(this.revisionId()).append(",");
        }
        if (this.revisionChangeIdentifier() != null) {
            sb.append("RevisionChangeIdentifier: ").append(this.revisionChangeIdentifier()).append(",");
        }
        if (this.revisionSummary() != null) {
            sb.append("RevisionSummary: ").append(this.revisionSummary()).append(",");
        }
        if (this.created() != null) {
            sb.append("Created: ").append(this.created()).append(",");
        }
        if (this.revisionUrl() != null) {
            sb.append("RevisionUrl: ").append(this.revisionUrl()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ArtifactRevisionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String name;
        private String revisionId;
        private String revisionChangeIdentifier;
        private String revisionSummary;
        private Date created;
        private String revisionUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(ArtifactRevision model) {
            this.setName(model.name);
            this.setRevisionId(model.revisionId);
            this.setRevisionChangeIdentifier(model.revisionChangeIdentifier);
            this.setRevisionSummary(model.revisionSummary);
            this.setCreated(model.created);
            this.setRevisionUrl(model.revisionUrl);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getRevisionId() {
            return this.revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        public final String getRevisionChangeIdentifier() {
            return this.revisionChangeIdentifier;
        }

        @Override
        public final Builder revisionChangeIdentifier(String revisionChangeIdentifier) {
            this.revisionChangeIdentifier = revisionChangeIdentifier;
            return this;
        }

        public final void setRevisionChangeIdentifier(String revisionChangeIdentifier) {
            this.revisionChangeIdentifier = revisionChangeIdentifier;
        }

        public final String getRevisionSummary() {
            return this.revisionSummary;
        }

        @Override
        public final Builder revisionSummary(String revisionSummary) {
            this.revisionSummary = revisionSummary;
            return this;
        }

        public final void setRevisionSummary(String revisionSummary) {
            this.revisionSummary = revisionSummary;
        }

        public final Date getCreated() {
            return this.created;
        }

        @Override
        public final Builder created(Date created) {
            this.created = StandardMemberCopier.copy(created);
            return this;
        }

        public final void setCreated(Date created) {
            this.created = StandardMemberCopier.copy(created);
        }

        public final String getRevisionUrl() {
            return this.revisionUrl;
        }

        @Override
        public final Builder revisionUrl(String revisionUrl) {
            this.revisionUrl = revisionUrl;
            return this;
        }

        public final void setRevisionUrl(String revisionUrl) {
            this.revisionUrl = revisionUrl;
        }

        @Override
        public ArtifactRevision build() {
            return new ArtifactRevision(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ArtifactRevision> {
        public Builder name(String var1);

        public Builder revisionId(String var1);

        public Builder revisionChangeIdentifier(String var1);

        public Builder revisionSummary(String var1);

        public Builder created(Date var1);

        public Builder revisionUrl(String var1);
    }
}

