/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.codepipeline.model.BlockerType;
import software.amazon.awssdk.services.codepipeline.transform.BlockerDeclarationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BlockerDeclaration
implements StructuredPojo,
ToCopyableBuilder<Builder, BlockerDeclaration> {
    private final String name;
    private final String type;

    private BlockerDeclaration(BuilderImpl builder) {
        this.name = builder.name;
        this.type = builder.type;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.type() == null ? 0 : this.type().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BlockerDeclaration)) {
            return false;
        }
        BlockerDeclaration other = (BlockerDeclaration)obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        return other.type() == null || other.type().equals(this.type());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.type() != null) {
            sb.append("Type: ").append(this.type()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BlockerDeclarationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String name;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(BlockerDeclaration model) {
            this.setName(model.name);
            this.setType(model.type);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(BlockerType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final void setType(BlockerType type) {
            this.type(type.toString());
        }

        @Override
        public BlockerDeclaration build() {
            return new BlockerDeclaration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BlockerDeclaration> {
        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(BlockerType var1);
    }
}

