/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.codepipeline.model.StageTransitionType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DisableStageTransitionRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DisableStageTransitionRequest> {
    private final String pipelineName;
    private final String stageName;
    private final String transitionType;
    private final String reason;

    private DisableStageTransitionRequest(BuilderImpl builder) {
        this.pipelineName = builder.pipelineName;
        this.stageName = builder.stageName;
        this.transitionType = builder.transitionType;
        this.reason = builder.reason;
    }

    public String pipelineName() {
        return this.pipelineName;
    }

    public String stageName() {
        return this.stageName;
    }

    public String transitionType() {
        return this.transitionType;
    }

    public String reason() {
        return this.reason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.pipelineName() == null ? 0 : this.pipelineName().hashCode());
        hashCode = 31 * hashCode + (this.stageName() == null ? 0 : this.stageName().hashCode());
        hashCode = 31 * hashCode + (this.transitionType() == null ? 0 : this.transitionType().hashCode());
        hashCode = 31 * hashCode + (this.reason() == null ? 0 : this.reason().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisableStageTransitionRequest)) {
            return false;
        }
        DisableStageTransitionRequest other = (DisableStageTransitionRequest)obj;
        if (other.pipelineName() == null ^ this.pipelineName() == null) {
            return false;
        }
        if (other.pipelineName() != null && !other.pipelineName().equals(this.pipelineName())) {
            return false;
        }
        if (other.stageName() == null ^ this.stageName() == null) {
            return false;
        }
        if (other.stageName() != null && !other.stageName().equals(this.stageName())) {
            return false;
        }
        if (other.transitionType() == null ^ this.transitionType() == null) {
            return false;
        }
        if (other.transitionType() != null && !other.transitionType().equals(this.transitionType())) {
            return false;
        }
        if (other.reason() == null ^ this.reason() == null) {
            return false;
        }
        return other.reason() == null || other.reason().equals(this.reason());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.pipelineName() != null) {
            sb.append("PipelineName: ").append(this.pipelineName()).append(",");
        }
        if (this.stageName() != null) {
            sb.append("StageName: ").append(this.stageName()).append(",");
        }
        if (this.transitionType() != null) {
            sb.append("TransitionType: ").append(this.transitionType()).append(",");
        }
        if (this.reason() != null) {
            sb.append("Reason: ").append(this.reason()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String pipelineName;
        private String stageName;
        private String transitionType;
        private String reason;

        private BuilderImpl() {
        }

        private BuilderImpl(DisableStageTransitionRequest model) {
            this.setPipelineName(model.pipelineName);
            this.setStageName(model.stageName);
            this.setTransitionType(model.transitionType);
            this.setReason(model.reason);
        }

        public final String getPipelineName() {
            return this.pipelineName;
        }

        @Override
        public final Builder pipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        public final void setPipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
        }

        public final String getStageName() {
            return this.stageName;
        }

        @Override
        public final Builder stageName(String stageName) {
            this.stageName = stageName;
            return this;
        }

        public final void setStageName(String stageName) {
            this.stageName = stageName;
        }

        public final String getTransitionType() {
            return this.transitionType;
        }

        @Override
        public final Builder transitionType(String transitionType) {
            this.transitionType = transitionType;
            return this;
        }

        @Override
        public final Builder transitionType(StageTransitionType transitionType) {
            this.transitionType(transitionType.toString());
            return this;
        }

        public final void setTransitionType(String transitionType) {
            this.transitionType = transitionType;
        }

        public final void setTransitionType(StageTransitionType transitionType) {
            this.transitionType(transitionType.toString());
        }

        public final String getReason() {
            return this.reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public DisableStageTransitionRequest build() {
            return new DisableStageTransitionRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DisableStageTransitionRequest> {
        public Builder pipelineName(String var1);

        public Builder stageName(String var1);

        public Builder transitionType(String var1);

        public Builder transitionType(StageTransitionType var1);

        public Builder reason(String var1);
    }
}

