/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.codepipeline.model.FailureType;
import software.amazon.awssdk.services.codepipeline.transform.FailureDetailsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class FailureDetails
implements StructuredPojo,
ToCopyableBuilder<Builder, FailureDetails> {
    private final String type;
    private final String message;
    private final String externalExecutionId;

    private FailureDetails(BuilderImpl builder) {
        this.type = builder.type;
        this.message = builder.message;
        this.externalExecutionId = builder.externalExecutionId;
    }

    public String type() {
        return this.type;
    }

    public String message() {
        return this.message;
    }

    public String externalExecutionId() {
        return this.externalExecutionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.type() == null ? 0 : this.type().hashCode());
        hashCode = 31 * hashCode + (this.message() == null ? 0 : this.message().hashCode());
        hashCode = 31 * hashCode + (this.externalExecutionId() == null ? 0 : this.externalExecutionId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailureDetails)) {
            return false;
        }
        FailureDetails other = (FailureDetails)obj;
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        if (other.message() == null ^ this.message() == null) {
            return false;
        }
        if (other.message() != null && !other.message().equals(this.message())) {
            return false;
        }
        if (other.externalExecutionId() == null ^ this.externalExecutionId() == null) {
            return false;
        }
        return other.externalExecutionId() == null || other.externalExecutionId().equals(this.externalExecutionId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.type() != null) {
            sb.append("Type: ").append(this.type()).append(",");
        }
        if (this.message() != null) {
            sb.append("Message: ").append(this.message()).append(",");
        }
        if (this.externalExecutionId() != null) {
            sb.append("ExternalExecutionId: ").append(this.externalExecutionId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FailureDetailsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String type;
        private String message;
        private String externalExecutionId;

        private BuilderImpl() {
        }

        private BuilderImpl(FailureDetails model) {
            this.setType(model.type);
            this.setMessage(model.message);
            this.setExternalExecutionId(model.externalExecutionId);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(FailureType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final void setType(FailureType type) {
            this.type(type.toString());
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final String getExternalExecutionId() {
            return this.externalExecutionId;
        }

        @Override
        public final Builder externalExecutionId(String externalExecutionId) {
            this.externalExecutionId = externalExecutionId;
            return this;
        }

        public final void setExternalExecutionId(String externalExecutionId) {
            this.externalExecutionId = externalExecutionId;
        }

        @Override
        public FailureDetails build() {
            return new FailureDetails(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, FailureDetails> {
        public Builder type(String var1);

        public Builder type(FailureType var1);

        public Builder message(String var1);

        public Builder externalExecutionId(String var1);
    }
}

