/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.stream.Stream;
import software.amazon.awssdk.util.StringUtils;

public enum FailureType {
    JobFailed("JobFailed"),
    ConfigurationError("ConfigurationError"),
    PermissionError("PermissionError"),
    RevisionOutOfSync("RevisionOutOfSync"),
    RevisionUnavailable("RevisionUnavailable"),
    SystemUnavailable("SystemUnavailable");

    private final String value;

    private FailureType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    public static FailureType fromValue(String value) {
        if (StringUtils.isNullOrEmpty(value)) {
            throw new IllegalArgumentException("Value cannot be null or empty!");
        }
        return Stream.of(FailureType.values()).filter(e -> e.toString().equals(value)).findFirst().orElseThrow(() -> new IllegalArgumentException("Cannot create enum from " + value + " value!"));
    }
}

