/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.codepipeline.model.ActionContext;
import software.amazon.awssdk.services.codepipeline.model.StageContext;
import software.amazon.awssdk.services.codepipeline.transform.PipelineContextMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PipelineContext
implements StructuredPojo,
ToCopyableBuilder<Builder, PipelineContext> {
    private final String pipelineName;
    private final StageContext stage;
    private final ActionContext action;

    private PipelineContext(BuilderImpl builder) {
        this.pipelineName = builder.pipelineName;
        this.stage = builder.stage;
        this.action = builder.action;
    }

    public String pipelineName() {
        return this.pipelineName;
    }

    public StageContext stage() {
        return this.stage;
    }

    public ActionContext action() {
        return this.action;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.pipelineName() == null ? 0 : this.pipelineName().hashCode());
        hashCode = 31 * hashCode + (this.stage() == null ? 0 : this.stage().hashCode());
        hashCode = 31 * hashCode + (this.action() == null ? 0 : this.action().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineContext)) {
            return false;
        }
        PipelineContext other = (PipelineContext)obj;
        if (other.pipelineName() == null ^ this.pipelineName() == null) {
            return false;
        }
        if (other.pipelineName() != null && !other.pipelineName().equals(this.pipelineName())) {
            return false;
        }
        if (other.stage() == null ^ this.stage() == null) {
            return false;
        }
        if (other.stage() != null && !other.stage().equals(this.stage())) {
            return false;
        }
        if (other.action() == null ^ this.action() == null) {
            return false;
        }
        return other.action() == null || other.action().equals(this.action());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.pipelineName() != null) {
            sb.append("PipelineName: ").append(this.pipelineName()).append(",");
        }
        if (this.stage() != null) {
            sb.append("Stage: ").append(this.stage()).append(",");
        }
        if (this.action() != null) {
            sb.append("Action: ").append(this.action()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PipelineContextMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String pipelineName;
        private StageContext stage;
        private ActionContext action;

        private BuilderImpl() {
        }

        private BuilderImpl(PipelineContext model) {
            this.setPipelineName(model.pipelineName);
            this.setStage(model.stage);
            this.setAction(model.action);
        }

        public final String getPipelineName() {
            return this.pipelineName;
        }

        @Override
        public final Builder pipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        public final void setPipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
        }

        public final StageContext getStage() {
            return this.stage;
        }

        @Override
        public final Builder stage(StageContext stage) {
            this.stage = stage;
            return this;
        }

        public final void setStage(StageContext stage) {
            this.stage = stage;
        }

        public final ActionContext getAction() {
            return this.action;
        }

        @Override
        public final Builder action(ActionContext action) {
            this.action = action;
            return this;
        }

        public final void setAction(ActionContext action) {
            this.action = action;
        }

        @Override
        public PipelineContext build() {
            return new PipelineContext(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PipelineContext> {
        public Builder pipelineName(String var1);

        public Builder stage(StageContext var1);

        public Builder action(ActionContext var1);
    }
}

