/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Date;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.codepipeline.model.PipelineExecutionStatus;
import software.amazon.awssdk.services.codepipeline.transform.PipelineExecutionSummaryMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PipelineExecutionSummary
implements StructuredPojo,
ToCopyableBuilder<Builder, PipelineExecutionSummary> {
    private final String pipelineExecutionId;
    private final String status;
    private final Date startTime;
    private final Date lastUpdateTime;

    private PipelineExecutionSummary(BuilderImpl builder) {
        this.pipelineExecutionId = builder.pipelineExecutionId;
        this.status = builder.status;
        this.startTime = builder.startTime;
        this.lastUpdateTime = builder.lastUpdateTime;
    }

    public String pipelineExecutionId() {
        return this.pipelineExecutionId;
    }

    public String status() {
        return this.status;
    }

    public Date startTime() {
        return this.startTime;
    }

    public Date lastUpdateTime() {
        return this.lastUpdateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.pipelineExecutionId() == null ? 0 : this.pipelineExecutionId().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.startTime() == null ? 0 : this.startTime().hashCode());
        hashCode = 31 * hashCode + (this.lastUpdateTime() == null ? 0 : this.lastUpdateTime().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineExecutionSummary)) {
            return false;
        }
        PipelineExecutionSummary other = (PipelineExecutionSummary)obj;
        if (other.pipelineExecutionId() == null ^ this.pipelineExecutionId() == null) {
            return false;
        }
        if (other.pipelineExecutionId() != null && !other.pipelineExecutionId().equals(this.pipelineExecutionId())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.startTime() == null ^ this.startTime() == null) {
            return false;
        }
        if (other.startTime() != null && !other.startTime().equals(this.startTime())) {
            return false;
        }
        if (other.lastUpdateTime() == null ^ this.lastUpdateTime() == null) {
            return false;
        }
        return other.lastUpdateTime() == null || other.lastUpdateTime().equals(this.lastUpdateTime());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.pipelineExecutionId() != null) {
            sb.append("PipelineExecutionId: ").append(this.pipelineExecutionId()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.startTime() != null) {
            sb.append("StartTime: ").append(this.startTime()).append(",");
        }
        if (this.lastUpdateTime() != null) {
            sb.append("LastUpdateTime: ").append(this.lastUpdateTime()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PipelineExecutionSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String pipelineExecutionId;
        private String status;
        private Date startTime;
        private Date lastUpdateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(PipelineExecutionSummary model) {
            this.setPipelineExecutionId(model.pipelineExecutionId);
            this.setStatus(model.status);
            this.setStartTime(model.startTime);
            this.setLastUpdateTime(model.lastUpdateTime);
        }

        public final String getPipelineExecutionId() {
            return this.pipelineExecutionId;
        }

        @Override
        public final Builder pipelineExecutionId(String pipelineExecutionId) {
            this.pipelineExecutionId = pipelineExecutionId;
            return this;
        }

        public final void setPipelineExecutionId(String pipelineExecutionId) {
            this.pipelineExecutionId = pipelineExecutionId;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(PipelineExecutionStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(PipelineExecutionStatus status) {
            this.status(status.toString());
        }

        public final Date getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Date startTime) {
            this.startTime = StandardMemberCopier.copy(startTime);
            return this;
        }

        public final void setStartTime(Date startTime) {
            this.startTime = StandardMemberCopier.copy(startTime);
        }

        public final Date getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Date lastUpdateTime) {
            this.lastUpdateTime = StandardMemberCopier.copy(lastUpdateTime);
            return this;
        }

        public final void setLastUpdateTime(Date lastUpdateTime) {
            this.lastUpdateTime = StandardMemberCopier.copy(lastUpdateTime);
        }

        @Override
        public PipelineExecutionSummary build() {
            return new PipelineExecutionSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PipelineExecutionSummary> {
        public Builder pipelineExecutionId(String var1);

        public Builder status(String var1);

        public Builder status(PipelineExecutionStatus var1);

        public Builder startTime(Date var1);

        public Builder lastUpdateTime(Date var1);
    }
}

