/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Date;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.codepipeline.transform.PipelineSummaryMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PipelineSummary
implements StructuredPojo,
ToCopyableBuilder<Builder, PipelineSummary> {
    private final String name;
    private final Integer version;
    private final Date created;
    private final Date updated;

    private PipelineSummary(BuilderImpl builder) {
        this.name = builder.name;
        this.version = builder.version;
        this.created = builder.created;
        this.updated = builder.updated;
    }

    public String name() {
        return this.name;
    }

    public Integer version() {
        return this.version;
    }

    public Date created() {
        return this.created;
    }

    public Date updated() {
        return this.updated;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.version() == null ? 0 : this.version().hashCode());
        hashCode = 31 * hashCode + (this.created() == null ? 0 : this.created().hashCode());
        hashCode = 31 * hashCode + (this.updated() == null ? 0 : this.updated().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineSummary)) {
            return false;
        }
        PipelineSummary other = (PipelineSummary)obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.version() == null ^ this.version() == null) {
            return false;
        }
        if (other.version() != null && !other.version().equals(this.version())) {
            return false;
        }
        if (other.created() == null ^ this.created() == null) {
            return false;
        }
        if (other.created() != null && !other.created().equals(this.created())) {
            return false;
        }
        if (other.updated() == null ^ this.updated() == null) {
            return false;
        }
        return other.updated() == null || other.updated().equals(this.updated());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.version() != null) {
            sb.append("Version: ").append(this.version()).append(",");
        }
        if (this.created() != null) {
            sb.append("Created: ").append(this.created()).append(",");
        }
        if (this.updated() != null) {
            sb.append("Updated: ").append(this.updated()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PipelineSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String name;
        private Integer version;
        private Date created;
        private Date updated;

        private BuilderImpl() {
        }

        private BuilderImpl(PipelineSummary model) {
            this.setName(model.name);
            this.setVersion(model.version);
            this.setCreated(model.created);
            this.setUpdated(model.updated);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Integer getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public final void setVersion(Integer version) {
            this.version = version;
        }

        public final Date getCreated() {
            return this.created;
        }

        @Override
        public final Builder created(Date created) {
            this.created = StandardMemberCopier.copy(created);
            return this;
        }

        public final void setCreated(Date created) {
            this.created = StandardMemberCopier.copy(created);
        }

        public final Date getUpdated() {
            return this.updated;
        }

        @Override
        public final Builder updated(Date updated) {
            this.updated = StandardMemberCopier.copy(updated);
            return this;
        }

        public final void setUpdated(Date updated) {
            this.updated = StandardMemberCopier.copy(updated);
        }

        @Override
        public PipelineSummary build() {
            return new PipelineSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PipelineSummary> {
        public Builder name(String var1);

        public Builder version(Integer var1);

        public Builder created(Date var1);

        public Builder updated(Date var1);
    }
}

