/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Map;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.codepipeline.model.ActionTypeId;
import software.amazon.awssdk.services.codepipeline.model.QueryParamMapCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PollForJobsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, PollForJobsRequest> {
    private final ActionTypeId actionTypeId;
    private final Integer maxBatchSize;
    private final Map<String, String> queryParam;

    private PollForJobsRequest(BuilderImpl builder) {
        this.actionTypeId = builder.actionTypeId;
        this.maxBatchSize = builder.maxBatchSize;
        this.queryParam = builder.queryParam;
    }

    public ActionTypeId actionTypeId() {
        return this.actionTypeId;
    }

    public Integer maxBatchSize() {
        return this.maxBatchSize;
    }

    public Map<String, String> queryParam() {
        return this.queryParam;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.actionTypeId() == null ? 0 : this.actionTypeId().hashCode());
        hashCode = 31 * hashCode + (this.maxBatchSize() == null ? 0 : this.maxBatchSize().hashCode());
        hashCode = 31 * hashCode + (this.queryParam() == null ? 0 : this.queryParam().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PollForJobsRequest)) {
            return false;
        }
        PollForJobsRequest other = (PollForJobsRequest)obj;
        if (other.actionTypeId() == null ^ this.actionTypeId() == null) {
            return false;
        }
        if (other.actionTypeId() != null && !other.actionTypeId().equals(this.actionTypeId())) {
            return false;
        }
        if (other.maxBatchSize() == null ^ this.maxBatchSize() == null) {
            return false;
        }
        if (other.maxBatchSize() != null && !other.maxBatchSize().equals(this.maxBatchSize())) {
            return false;
        }
        if (other.queryParam() == null ^ this.queryParam() == null) {
            return false;
        }
        return other.queryParam() == null || other.queryParam().equals(this.queryParam());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.actionTypeId() != null) {
            sb.append("ActionTypeId: ").append(this.actionTypeId()).append(",");
        }
        if (this.maxBatchSize() != null) {
            sb.append("MaxBatchSize: ").append(this.maxBatchSize()).append(",");
        }
        if (this.queryParam() != null) {
            sb.append("QueryParam: ").append(this.queryParam()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private ActionTypeId actionTypeId;
        private Integer maxBatchSize;
        private Map<String, String> queryParam;

        private BuilderImpl() {
        }

        private BuilderImpl(PollForJobsRequest model) {
            this.setActionTypeId(model.actionTypeId);
            this.setMaxBatchSize(model.maxBatchSize);
            this.setQueryParam(model.queryParam);
        }

        public final ActionTypeId getActionTypeId() {
            return this.actionTypeId;
        }

        @Override
        public final Builder actionTypeId(ActionTypeId actionTypeId) {
            this.actionTypeId = actionTypeId;
            return this;
        }

        public final void setActionTypeId(ActionTypeId actionTypeId) {
            this.actionTypeId = actionTypeId;
        }

        public final Integer getMaxBatchSize() {
            return this.maxBatchSize;
        }

        @Override
        public final Builder maxBatchSize(Integer maxBatchSize) {
            this.maxBatchSize = maxBatchSize;
            return this;
        }

        public final void setMaxBatchSize(Integer maxBatchSize) {
            this.maxBatchSize = maxBatchSize;
        }

        public final Map<String, String> getQueryParam() {
            return this.queryParam;
        }

        @Override
        public final Builder queryParam(Map<String, String> queryParam) {
            this.queryParam = QueryParamMapCopier.copy(queryParam);
            return this;
        }

        public final void setQueryParam(Map<String, String> queryParam) {
            this.queryParam = QueryParamMapCopier.copy(queryParam);
        }

        @Override
        public PollForJobsRequest build() {
            return new PollForJobsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PollForJobsRequest> {
        public Builder actionTypeId(ActionTypeId var1);

        public Builder maxBatchSize(Integer var1);

        public Builder queryParam(Map<String, String> var1);
    }
}

