/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.codepipeline.model.Job;
import software.amazon.awssdk.services.codepipeline.model.JobListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PollForJobsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, PollForJobsResponse> {
    private final List<Job> jobs;

    private PollForJobsResponse(BuilderImpl builder) {
        this.jobs = builder.jobs;
    }

    public List<Job> jobs() {
        return this.jobs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.jobs() == null ? 0 : this.jobs().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PollForJobsResponse)) {
            return false;
        }
        PollForJobsResponse other = (PollForJobsResponse)obj;
        if (other.jobs() == null ^ this.jobs() == null) {
            return false;
        }
        return other.jobs() == null || other.jobs().equals(this.jobs());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.jobs() != null) {
            sb.append("Jobs: ").append(this.jobs()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Job> jobs;

        private BuilderImpl() {
        }

        private BuilderImpl(PollForJobsResponse model) {
            this.setJobs(model.jobs);
        }

        public final Collection<Job> getJobs() {
            return this.jobs;
        }

        @Override
        public final Builder jobs(Collection<Job> jobs) {
            this.jobs = JobListCopier.copy(jobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobs(Job ... jobs) {
            if (this.jobs == null) {
                this.jobs = new ArrayList<Job>(jobs.length);
            }
            for (Job e : jobs) {
                this.jobs.add(e);
            }
            return this;
        }

        public final void setJobs(Collection<Job> jobs) {
            this.jobs = JobListCopier.copy(jobs);
        }

        @SafeVarargs
        public final void setJobs(Job ... jobs) {
            if (this.jobs == null) {
                this.jobs = new ArrayList<Job>(jobs.length);
            }
            for (Job e : jobs) {
                this.jobs.add(e);
            }
        }

        @Override
        public PollForJobsResponse build() {
            return new PollForJobsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PollForJobsResponse> {
        public Builder jobs(Collection<Job> var1);

        public Builder jobs(Job ... var1);
    }
}

