/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codepipeline.model.AWSSessionCredentials;

@SdkInternalApi
public class AWSSessionCredentialsMarshaller {
    private static final MarshallingInfo<String> ACCESSKEYID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("accessKeyId").build();
    private static final MarshallingInfo<String> SECRETACCESSKEY_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("secretAccessKey").build();
    private static final MarshallingInfo<String> SESSIONTOKEN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sessionToken").build();
    private static final AWSSessionCredentialsMarshaller instance = new AWSSessionCredentialsMarshaller();

    public static AWSSessionCredentialsMarshaller getInstance() {
        return instance;
    }

    public void marshall(AWSSessionCredentials awsSessionCredentials, ProtocolMarshaller protocolMarshaller) {
        if (awsSessionCredentials == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(awsSessionCredentials.accessKeyId(), ACCESSKEYID_BINDING);
            protocolMarshaller.marshall(awsSessionCredentials.secretAccessKey(), SECRETACCESSKEY_BINDING);
            protocolMarshaller.marshall(awsSessionCredentials.sessionToken(), SESSIONTOKEN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

