/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.transform;

import java.util.Date;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codepipeline.model.ActionRevision;

@SdkInternalApi
public class ActionRevisionMarshaller {
    private static final MarshallingInfo<String> REVISIONID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("revisionId").build();
    private static final MarshallingInfo<String> REVISIONCHANGEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("revisionChangeId").build();
    private static final MarshallingInfo<Date> CREATED_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("created").build();
    private static final ActionRevisionMarshaller instance = new ActionRevisionMarshaller();

    public static ActionRevisionMarshaller getInstance() {
        return instance;
    }

    public void marshall(ActionRevision actionRevision, ProtocolMarshaller protocolMarshaller) {
        if (actionRevision == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(actionRevision.revisionId(), REVISIONID_BINDING);
            protocolMarshaller.marshall(actionRevision.revisionChangeId(), REVISIONCHANGEID_BINDING);
            protocolMarshaller.marshall(actionRevision.created(), CREATED_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

