/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.codepipeline.model.ActionState;

@SdkInternalApi
public class ActionStateMarshaller {
    private static final MarshallingInfo<String> ACTIONNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("actionName").build();
    private static final MarshallingInfo<StructuredPojo> CURRENTREVISION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("currentRevision").build();
    private static final MarshallingInfo<StructuredPojo> LATESTEXECUTION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("latestExecution").build();
    private static final MarshallingInfo<String> ENTITYURL_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("entityUrl").build();
    private static final MarshallingInfo<String> REVISIONURL_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("revisionUrl").build();
    private static final ActionStateMarshaller instance = new ActionStateMarshaller();

    public static ActionStateMarshaller getInstance() {
        return instance;
    }

    public void marshall(ActionState actionState, ProtocolMarshaller protocolMarshaller) {
        if (actionState == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(actionState.actionName(), ACTIONNAME_BINDING);
            protocolMarshaller.marshall(actionState.currentRevision(), CURRENTREVISION_BINDING);
            protocolMarshaller.marshall(actionState.latestExecution(), LATESTEXECUTION_BINDING);
            protocolMarshaller.marshall(actionState.entityUrl(), ENTITYURL_BINDING);
            protocolMarshaller.marshall(actionState.revisionUrl(), REVISIONURL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

