/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.codepipeline.model.ActionConfigurationProperty;
import software.amazon.awssdk.services.codepipeline.model.ActionType;
import software.amazon.awssdk.services.codepipeline.transform.ActionConfigurationPropertyUnmarshaller;
import software.amazon.awssdk.services.codepipeline.transform.ActionTypeIdUnmarshaller;
import software.amazon.awssdk.services.codepipeline.transform.ActionTypeSettingsUnmarshaller;
import software.amazon.awssdk.services.codepipeline.transform.ArtifactDetailsUnmarshaller;

public class ActionTypeUnmarshaller
implements Unmarshaller<ActionType, JsonUnmarshallerContext> {
    private static ActionTypeUnmarshaller INSTANCE;

    @Override
    public ActionType unmarshall(JsonUnmarshallerContext context) throws Exception {
        ActionType.Builder actionTypeBuilder = ActionType.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("id", targetDepth)) {
                    context.nextToken();
                    actionTypeBuilder.id(ActionTypeIdUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("settings", targetDepth)) {
                    context.nextToken();
                    actionTypeBuilder.settings(ActionTypeSettingsUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("actionConfigurationProperties", targetDepth)) {
                    context.nextToken();
                    actionTypeBuilder.actionConfigurationProperties(new ListUnmarshaller<ActionConfigurationProperty>(ActionConfigurationPropertyUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("inputArtifactDetails", targetDepth)) {
                    context.nextToken();
                    actionTypeBuilder.inputArtifactDetails(ArtifactDetailsUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("outputArtifactDetails", targetDepth)) {
                    context.nextToken();
                    actionTypeBuilder.outputArtifactDetails(ArtifactDetailsUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (ActionType)actionTypeBuilder.build();
    }

    public static ActionTypeUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ActionTypeUnmarshaller();
        }
        return INSTANCE;
    }
}

