/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codepipeline.model.ArtifactDetails;

@SdkInternalApi
public class ArtifactDetailsMarshaller {
    private static final MarshallingInfo<Integer> MINIMUMCOUNT_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("minimumCount").build();
    private static final MarshallingInfo<Integer> MAXIMUMCOUNT_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("maximumCount").build();
    private static final ArtifactDetailsMarshaller instance = new ArtifactDetailsMarshaller();

    public static ArtifactDetailsMarshaller getInstance() {
        return instance;
    }

    public void marshall(ArtifactDetails artifactDetails, ProtocolMarshaller protocolMarshaller) {
        if (artifactDetails == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(artifactDetails.minimumCount(), MINIMUMCOUNT_BINDING);
            protocolMarshaller.marshall(artifactDetails.maximumCount(), MAXIMUMCOUNT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

