/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.transform;

import java.util.Date;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codepipeline.model.ArtifactRevision;

@SdkInternalApi
public class ArtifactRevisionMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<String> REVISIONID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("revisionId").build();
    private static final MarshallingInfo<String> REVISIONCHANGEIDENTIFIER_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("revisionChangeIdentifier").build();
    private static final MarshallingInfo<String> REVISIONSUMMARY_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("revisionSummary").build();
    private static final MarshallingInfo<Date> CREATED_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("created").build();
    private static final MarshallingInfo<String> REVISIONURL_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("revisionUrl").build();
    private static final ArtifactRevisionMarshaller instance = new ArtifactRevisionMarshaller();

    public static ArtifactRevisionMarshaller getInstance() {
        return instance;
    }

    public void marshall(ArtifactRevision artifactRevision, ProtocolMarshaller protocolMarshaller) {
        if (artifactRevision == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(artifactRevision.name(), NAME_BINDING);
            protocolMarshaller.marshall(artifactRevision.revisionId(), REVISIONID_BINDING);
            protocolMarshaller.marshall(artifactRevision.revisionChangeIdentifier(), REVISIONCHANGEIDENTIFIER_BINDING);
            protocolMarshaller.marshall(artifactRevision.revisionSummary(), REVISIONSUMMARY_BINDING);
            protocolMarshaller.marshall(artifactRevision.created(), CREATED_BINDING);
            protocolMarshaller.marshall(artifactRevision.revisionUrl(), REVISIONURL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

