/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codepipeline.model.ExecutionDetails;

@SdkInternalApi
public class ExecutionDetailsMarshaller {
    private static final MarshallingInfo<String> SUMMARY_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("summary").build();
    private static final MarshallingInfo<String> EXTERNALEXECUTIONID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("externalExecutionId").build();
    private static final MarshallingInfo<Integer> PERCENTCOMPLETE_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("percentComplete").build();
    private static final ExecutionDetailsMarshaller instance = new ExecutionDetailsMarshaller();

    public static ExecutionDetailsMarshaller getInstance() {
        return instance;
    }

    public void marshall(ExecutionDetails executionDetails, ProtocolMarshaller protocolMarshaller) {
        if (executionDetails == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(executionDetails.summary(), SUMMARY_BINDING);
            protocolMarshaller.marshall(executionDetails.externalExecutionId(), EXTERNALEXECUTIONID_BINDING);
            protocolMarshaller.marshall(executionDetails.percentComplete(), PERCENTCOMPLETE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

