/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.codepipeline.model.PipelineDeclaration;
import software.amazon.awssdk.services.codepipeline.model.StageDeclaration;
import software.amazon.awssdk.services.codepipeline.transform.ArtifactStoreUnmarshaller;
import software.amazon.awssdk.services.codepipeline.transform.StageDeclarationUnmarshaller;

public class PipelineDeclarationUnmarshaller
implements Unmarshaller<PipelineDeclaration, JsonUnmarshallerContext> {
    private static PipelineDeclarationUnmarshaller INSTANCE;

    @Override
    public PipelineDeclaration unmarshall(JsonUnmarshallerContext context) throws Exception {
        PipelineDeclaration.Builder pipelineDeclarationBuilder = PipelineDeclaration.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("name", targetDepth)) {
                    context.nextToken();
                    pipelineDeclarationBuilder.name(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("roleArn", targetDepth)) {
                    context.nextToken();
                    pipelineDeclarationBuilder.roleArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("artifactStore", targetDepth)) {
                    context.nextToken();
                    pipelineDeclarationBuilder.artifactStore(ArtifactStoreUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("stages", targetDepth)) {
                    context.nextToken();
                    pipelineDeclarationBuilder.stages(new ListUnmarshaller<StageDeclaration>(StageDeclarationUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("version", targetDepth)) {
                    context.nextToken();
                    pipelineDeclarationBuilder.version(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (PipelineDeclaration)pipelineDeclarationBuilder.build();
    }

    public static PipelineDeclarationUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PipelineDeclarationUnmarshaller();
        }
        return INSTANCE;
    }
}

