/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.transform;

import java.util.Date;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codepipeline.model.PipelineSummary;

@SdkInternalApi
public class PipelineSummaryMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<Integer> VERSION_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("version").build();
    private static final MarshallingInfo<Date> CREATED_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("created").build();
    private static final MarshallingInfo<Date> UPDATED_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("updated").build();
    private static final PipelineSummaryMarshaller instance = new PipelineSummaryMarshaller();

    public static PipelineSummaryMarshaller getInstance() {
        return instance;
    }

    public void marshall(PipelineSummary pipelineSummary, ProtocolMarshaller protocolMarshaller) {
        if (pipelineSummary == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(pipelineSummary.name(), NAME_BINDING);
            protocolMarshaller.marshall(pipelineSummary.version(), VERSION_BINDING);
            protocolMarshaller.marshall(pipelineSummary.created(), CREATED_BINDING);
            protocolMarshaller.marshall(pipelineSummary.updated(), UPDATED_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

