/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.codepipeline.model.StageContext;

public class StageContextUnmarshaller
implements Unmarshaller<StageContext, JsonUnmarshallerContext> {
    private static StageContextUnmarshaller INSTANCE;

    @Override
    public StageContext unmarshall(JsonUnmarshallerContext context) throws Exception {
        StageContext.Builder stageContextBuilder = StageContext.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("name", targetDepth)) {
                    context.nextToken();
                    stageContextBuilder.name(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (StageContext)stageContextBuilder.build();
    }

    public static StageContextUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new StageContextUnmarshaller();
        }
        return INSTANCE;
    }
}

