/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.transform;

import java.util.Date;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codepipeline.model.TransitionState;

@SdkInternalApi
public class TransitionStateMarshaller {
    private static final MarshallingInfo<Boolean> ENABLED_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("enabled").build();
    private static final MarshallingInfo<String> LASTCHANGEDBY_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastChangedBy").build();
    private static final MarshallingInfo<Date> LASTCHANGEDAT_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastChangedAt").build();
    private static final MarshallingInfo<String> DISABLEDREASON_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("disabledReason").build();
    private static final TransitionStateMarshaller instance = new TransitionStateMarshaller();

    public static TransitionStateMarshaller getInstance() {
        return instance;
    }

    public void marshall(TransitionState transitionState, ProtocolMarshaller protocolMarshaller) {
        if (transitionState == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(transitionState.enabled(), ENABLED_BINDING);
            protocolMarshaller.marshall(transitionState.lastChangedBy(), LASTCHANGEDBY_BINDING);
            protocolMarshaller.marshall(transitionState.lastChangedAt(), LASTCHANGEDAT_BINDING);
            protocolMarshaller.marshall(transitionState.disabledReason(), DISABLEDREASON_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

