/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.util.Date;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.codepipeline.model.TransitionState;

public class TransitionStateUnmarshaller
implements Unmarshaller<TransitionState, JsonUnmarshallerContext> {
    private static TransitionStateUnmarshaller INSTANCE;

    @Override
    public TransitionState unmarshall(JsonUnmarshallerContext context) throws Exception {
        TransitionState.Builder transitionStateBuilder = TransitionState.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("enabled", targetDepth)) {
                    context.nextToken();
                    transitionStateBuilder.enabled(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("lastChangedBy", targetDepth)) {
                    context.nextToken();
                    transitionStateBuilder.lastChangedBy(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("lastChangedAt", targetDepth)) {
                    context.nextToken();
                    transitionStateBuilder.lastChangedAt(context.getUnmarshaller(Date.class).unmarshall(context));
                }
                if (context.testExpression("disabledReason", targetDepth)) {
                    context.nextToken();
                    transitionStateBuilder.disabledReason(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (TransitionState)transitionStateBuilder.build();
    }

    public static TransitionStateUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new TransitionStateUnmarshaller();
        }
        return INSTANCE;
    }
}

