/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.iam.model.SimulationPolicyListTypeCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetContextKeysForPrincipalPolicyRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetContextKeysForPrincipalPolicyRequest> {
    private final String policySourceArn;
    private final List<String> policyInputList;

    private GetContextKeysForPrincipalPolicyRequest(BuilderImpl builder) {
        this.policySourceArn = builder.policySourceArn;
        this.policyInputList = builder.policyInputList;
    }

    public String policySourceArn() {
        return this.policySourceArn;
    }

    public List<String> policyInputList() {
        return this.policyInputList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.policySourceArn() == null ? 0 : this.policySourceArn().hashCode());
        hashCode = 31 * hashCode + (this.policyInputList() == null ? 0 : this.policyInputList().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetContextKeysForPrincipalPolicyRequest)) {
            return false;
        }
        GetContextKeysForPrincipalPolicyRequest other = (GetContextKeysForPrincipalPolicyRequest)obj;
        if (other.policySourceArn() == null ^ this.policySourceArn() == null) {
            return false;
        }
        if (other.policySourceArn() != null && !other.policySourceArn().equals(this.policySourceArn())) {
            return false;
        }
        if (other.policyInputList() == null ^ this.policyInputList() == null) {
            return false;
        }
        return other.policyInputList() == null || other.policyInputList().equals(this.policyInputList());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.policySourceArn() != null) {
            sb.append("PolicySourceArn: ").append(this.policySourceArn()).append(",");
        }
        if (this.policyInputList() != null) {
            sb.append("PolicyInputList: ").append(this.policyInputList()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String policySourceArn;
        private List<String> policyInputList = new SdkInternalList<String>();

        private BuilderImpl() {
        }

        private BuilderImpl(GetContextKeysForPrincipalPolicyRequest model) {
            this.setPolicySourceArn(model.policySourceArn);
            this.setPolicyInputList(model.policyInputList);
        }

        public final String getPolicySourceArn() {
            return this.policySourceArn;
        }

        @Override
        public final Builder policySourceArn(String policySourceArn) {
            this.policySourceArn = policySourceArn;
            return this;
        }

        public final void setPolicySourceArn(String policySourceArn) {
            this.policySourceArn = policySourceArn;
        }

        public final Collection<String> getPolicyInputList() {
            return this.policyInputList;
        }

        @Override
        public final Builder policyInputList(Collection<String> policyInputList) {
            this.policyInputList = SimulationPolicyListTypeCopier.copy(policyInputList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyInputList(String ... policyInputList) {
            if (this.policyInputList == null) {
                this.policyInputList = new SdkInternalList<String>(policyInputList.length);
            }
            for (String e : policyInputList) {
                this.policyInputList.add(e);
            }
            return this;
        }

        public final void setPolicyInputList(Collection<String> policyInputList) {
            this.policyInputList = SimulationPolicyListTypeCopier.copy(policyInputList);
        }

        @SafeVarargs
        public final void setPolicyInputList(String ... policyInputList) {
            if (this.policyInputList == null) {
                this.policyInputList = new SdkInternalList<String>(policyInputList.length);
            }
            for (String e : policyInputList) {
                this.policyInputList.add(e);
            }
        }

        @Override
        public GetContextKeysForPrincipalPolicyRequest build() {
            return new GetContextKeysForPrincipalPolicyRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetContextKeysForPrincipalPolicyRequest> {
        public Builder policySourceArn(String var1);

        public Builder policyInputList(Collection<String> var1);

        public Builder policyInputList(String ... var1);
    }
}

