/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.iam.model._clientIDListTypeCopier;
import software.amazon.awssdk.services.iam.model._thumbprintListTypeCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetOpenIDConnectProviderResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetOpenIDConnectProviderResponse> {
    private final String url;
    private final List<String> clientIDList;
    private final List<String> thumbprintList;
    private final Date createDate;

    private GetOpenIDConnectProviderResponse(BuilderImpl builder) {
        this.url = builder.url;
        this.clientIDList = builder.clientIDList;
        this.thumbprintList = builder.thumbprintList;
        this.createDate = builder.createDate;
    }

    public String url() {
        return this.url;
    }

    public List<String> clientIDList() {
        return this.clientIDList;
    }

    public List<String> thumbprintList() {
        return this.thumbprintList;
    }

    public Date createDate() {
        return this.createDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.url() == null ? 0 : this.url().hashCode());
        hashCode = 31 * hashCode + (this.clientIDList() == null ? 0 : this.clientIDList().hashCode());
        hashCode = 31 * hashCode + (this.thumbprintList() == null ? 0 : this.thumbprintList().hashCode());
        hashCode = 31 * hashCode + (this.createDate() == null ? 0 : this.createDate().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOpenIDConnectProviderResponse)) {
            return false;
        }
        GetOpenIDConnectProviderResponse other = (GetOpenIDConnectProviderResponse)obj;
        if (other.url() == null ^ this.url() == null) {
            return false;
        }
        if (other.url() != null && !other.url().equals(this.url())) {
            return false;
        }
        if (other.clientIDList() == null ^ this.clientIDList() == null) {
            return false;
        }
        if (other.clientIDList() != null && !other.clientIDList().equals(this.clientIDList())) {
            return false;
        }
        if (other.thumbprintList() == null ^ this.thumbprintList() == null) {
            return false;
        }
        if (other.thumbprintList() != null && !other.thumbprintList().equals(this.thumbprintList())) {
            return false;
        }
        if (other.createDate() == null ^ this.createDate() == null) {
            return false;
        }
        return other.createDate() == null || other.createDate().equals(this.createDate());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.url() != null) {
            sb.append("Url: ").append(this.url()).append(",");
        }
        if (this.clientIDList() != null) {
            sb.append("ClientIDList: ").append(this.clientIDList()).append(",");
        }
        if (this.thumbprintList() != null) {
            sb.append("ThumbprintList: ").append(this.thumbprintList()).append(",");
        }
        if (this.createDate() != null) {
            sb.append("CreateDate: ").append(this.createDate()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String url;
        private List<String> clientIDList = new SdkInternalList<String>();
        private List<String> thumbprintList = new SdkInternalList<String>();
        private Date createDate;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOpenIDConnectProviderResponse model) {
            this.setUrl(model.url);
            this.setClientIDList(model.clientIDList);
            this.setThumbprintList(model.thumbprintList);
            this.setCreateDate(model.createDate);
        }

        public final String getUrl() {
            return this.url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        public final Collection<String> getClientIDList() {
            return this.clientIDList;
        }

        @Override
        public final Builder clientIDList(Collection<String> clientIDList) {
            this.clientIDList = _clientIDListTypeCopier.copy(clientIDList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clientIDList(String ... clientIDList) {
            if (this.clientIDList == null) {
                this.clientIDList = new SdkInternalList<String>(clientIDList.length);
            }
            for (String e : clientIDList) {
                this.clientIDList.add(e);
            }
            return this;
        }

        public final void setClientIDList(Collection<String> clientIDList) {
            this.clientIDList = _clientIDListTypeCopier.copy(clientIDList);
        }

        @SafeVarargs
        public final void setClientIDList(String ... clientIDList) {
            if (this.clientIDList == null) {
                this.clientIDList = new SdkInternalList<String>(clientIDList.length);
            }
            for (String e : clientIDList) {
                this.clientIDList.add(e);
            }
        }

        public final Collection<String> getThumbprintList() {
            return this.thumbprintList;
        }

        @Override
        public final Builder thumbprintList(Collection<String> thumbprintList) {
            this.thumbprintList = _thumbprintListTypeCopier.copy(thumbprintList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder thumbprintList(String ... thumbprintList) {
            if (this.thumbprintList == null) {
                this.thumbprintList = new SdkInternalList<String>(thumbprintList.length);
            }
            for (String e : thumbprintList) {
                this.thumbprintList.add(e);
            }
            return this;
        }

        public final void setThumbprintList(Collection<String> thumbprintList) {
            this.thumbprintList = _thumbprintListTypeCopier.copy(thumbprintList);
        }

        @SafeVarargs
        public final void setThumbprintList(String ... thumbprintList) {
            if (this.thumbprintList == null) {
                this.thumbprintList = new SdkInternalList<String>(thumbprintList.length);
            }
            for (String e : thumbprintList) {
                this.thumbprintList.add(e);
            }
        }

        public final Date getCreateDate() {
            return this.createDate;
        }

        @Override
        public final Builder createDate(Date createDate) {
            this.createDate = StandardMemberCopier.copy(createDate);
            return this;
        }

        public final void setCreateDate(Date createDate) {
            this.createDate = StandardMemberCopier.copy(createDate);
        }

        @Override
        public GetOpenIDConnectProviderResponse build() {
            return new GetOpenIDConnectProviderResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetOpenIDConnectProviderResponse> {
        public Builder url(String var1);

        public Builder clientIDList(Collection<String> var1);

        public Builder clientIDList(String ... var1);

        public Builder thumbprintList(Collection<String> var1);

        public Builder thumbprintList(String ... var1);

        public Builder createDate(Date var1);
    }
}

