/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Date;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Group
implements ToCopyableBuilder<Builder, Group> {
    private final String path;
    private final String groupName;
    private final String groupId;
    private final String arn;
    private final Date createDate;

    private Group(BuilderImpl builder) {
        this.path = builder.path;
        this.groupName = builder.groupName;
        this.groupId = builder.groupId;
        this.arn = builder.arn;
        this.createDate = builder.createDate;
    }

    public String path() {
        return this.path;
    }

    public String groupName() {
        return this.groupName;
    }

    public String groupId() {
        return this.groupId;
    }

    public String arn() {
        return this.arn;
    }

    public Date createDate() {
        return this.createDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.path() == null ? 0 : this.path().hashCode());
        hashCode = 31 * hashCode + (this.groupName() == null ? 0 : this.groupName().hashCode());
        hashCode = 31 * hashCode + (this.groupId() == null ? 0 : this.groupId().hashCode());
        hashCode = 31 * hashCode + (this.arn() == null ? 0 : this.arn().hashCode());
        hashCode = 31 * hashCode + (this.createDate() == null ? 0 : this.createDate().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Group)) {
            return false;
        }
        Group other = (Group)obj;
        if (other.path() == null ^ this.path() == null) {
            return false;
        }
        if (other.path() != null && !other.path().equals(this.path())) {
            return false;
        }
        if (other.groupName() == null ^ this.groupName() == null) {
            return false;
        }
        if (other.groupName() != null && !other.groupName().equals(this.groupName())) {
            return false;
        }
        if (other.groupId() == null ^ this.groupId() == null) {
            return false;
        }
        if (other.groupId() != null && !other.groupId().equals(this.groupId())) {
            return false;
        }
        if (other.arn() == null ^ this.arn() == null) {
            return false;
        }
        if (other.arn() != null && !other.arn().equals(this.arn())) {
            return false;
        }
        if (other.createDate() == null ^ this.createDate() == null) {
            return false;
        }
        return other.createDate() == null || other.createDate().equals(this.createDate());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.path() != null) {
            sb.append("Path: ").append(this.path()).append(",");
        }
        if (this.groupName() != null) {
            sb.append("GroupName: ").append(this.groupName()).append(",");
        }
        if (this.groupId() != null) {
            sb.append("GroupId: ").append(this.groupId()).append(",");
        }
        if (this.arn() != null) {
            sb.append("Arn: ").append(this.arn()).append(",");
        }
        if (this.createDate() != null) {
            sb.append("CreateDate: ").append(this.createDate()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String path;
        private String groupName;
        private String groupId;
        private String arn;
        private Date createDate;

        private BuilderImpl() {
        }

        private BuilderImpl(Group model) {
            this.setPath(model.path);
            this.setGroupName(model.groupName);
            this.setGroupId(model.groupId);
            this.setArn(model.arn);
            this.setCreateDate(model.createDate);
        }

        public final String getPath() {
            return this.path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        public final String getGroupName() {
            return this.groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final String getGroupId() {
            return this.groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Date getCreateDate() {
            return this.createDate;
        }

        @Override
        public final Builder createDate(Date createDate) {
            this.createDate = StandardMemberCopier.copy(createDate);
            return this;
        }

        public final void setCreateDate(Date createDate) {
            this.createDate = StandardMemberCopier.copy(createDate);
        }

        @Override
        public Group build() {
            return new Group(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Group> {
        public Builder path(String var1);

        public Builder groupName(String var1);

        public Builder groupId(String var1);

        public Builder arn(String var1);

        public Builder createDate(Date var1);
    }
}

