/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.iam.model.PolicyVersion;
import software.amazon.awssdk.services.iam.model._policyDocumentVersionListTypeCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListPolicyVersionsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListPolicyVersionsResponse> {
    private final List<PolicyVersion> versions;
    private final Boolean isTruncated;
    private final String marker;

    private ListPolicyVersionsResponse(BuilderImpl builder) {
        this.versions = builder.versions;
        this.isTruncated = builder.isTruncated;
        this.marker = builder.marker;
    }

    public List<PolicyVersion> versions() {
        return this.versions;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public String marker() {
        return this.marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.versions() == null ? 0 : this.versions().hashCode());
        hashCode = 31 * hashCode + (this.isTruncated() == null ? 0 : this.isTruncated().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPolicyVersionsResponse)) {
            return false;
        }
        ListPolicyVersionsResponse other = (ListPolicyVersionsResponse)obj;
        if (other.versions() == null ^ this.versions() == null) {
            return false;
        }
        if (other.versions() != null && !other.versions().equals(this.versions())) {
            return false;
        }
        if (other.isTruncated() == null ^ this.isTruncated() == null) {
            return false;
        }
        if (other.isTruncated() != null && !other.isTruncated().equals(this.isTruncated())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        return other.marker() == null || other.marker().equals(this.marker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.versions() != null) {
            sb.append("Versions: ").append(this.versions()).append(",");
        }
        if (this.isTruncated() != null) {
            sb.append("IsTruncated: ").append(this.isTruncated()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<PolicyVersion> versions = new SdkInternalList<PolicyVersion>();
        private Boolean isTruncated;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPolicyVersionsResponse model) {
            this.setVersions(model.versions);
            this.setIsTruncated(model.isTruncated);
            this.setMarker(model.marker);
        }

        public final Collection<PolicyVersion> getVersions() {
            return this.versions;
        }

        @Override
        public final Builder versions(Collection<PolicyVersion> versions) {
            this.versions = _policyDocumentVersionListTypeCopier.copy(versions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder versions(PolicyVersion ... versions) {
            if (this.versions == null) {
                this.versions = new SdkInternalList<PolicyVersion>(versions.length);
            }
            for (PolicyVersion e : versions) {
                this.versions.add(e);
            }
            return this;
        }

        public final void setVersions(Collection<PolicyVersion> versions) {
            this.versions = _policyDocumentVersionListTypeCopier.copy(versions);
        }

        @SafeVarargs
        public final void setVersions(PolicyVersion ... versions) {
            if (this.versions == null) {
                this.versions = new SdkInternalList<PolicyVersion>(versions.length);
            }
            for (PolicyVersion e : versions) {
                this.versions.add(e);
            }
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public ListPolicyVersionsResponse build() {
            return new ListPolicyVersionsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListPolicyVersionsResponse> {
        public Builder versions(Collection<PolicyVersion> var1);

        public Builder versions(PolicyVersion ... var1);

        public Builder isTruncated(Boolean var1);

        public Builder marker(String var1);
    }
}

