/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.iam.model.Role;
import software.amazon.awssdk.services.iam.model._roleListTypeCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListRolesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListRolesResponse> {
    private final List<Role> roles;
    private final Boolean isTruncated;
    private final String marker;

    private ListRolesResponse(BuilderImpl builder) {
        this.roles = builder.roles;
        this.isTruncated = builder.isTruncated;
        this.marker = builder.marker;
    }

    public List<Role> roles() {
        return this.roles;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public String marker() {
        return this.marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.roles() == null ? 0 : this.roles().hashCode());
        hashCode = 31 * hashCode + (this.isTruncated() == null ? 0 : this.isTruncated().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRolesResponse)) {
            return false;
        }
        ListRolesResponse other = (ListRolesResponse)obj;
        if (other.roles() == null ^ this.roles() == null) {
            return false;
        }
        if (other.roles() != null && !other.roles().equals(this.roles())) {
            return false;
        }
        if (other.isTruncated() == null ^ this.isTruncated() == null) {
            return false;
        }
        if (other.isTruncated() != null && !other.isTruncated().equals(this.isTruncated())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        return other.marker() == null || other.marker().equals(this.marker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.roles() != null) {
            sb.append("Roles: ").append(this.roles()).append(",");
        }
        if (this.isTruncated() != null) {
            sb.append("IsTruncated: ").append(this.isTruncated()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Role> roles = new SdkInternalList<Role>();
        private Boolean isTruncated;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRolesResponse model) {
            this.setRoles(model.roles);
            this.setIsTruncated(model.isTruncated);
            this.setMarker(model.marker);
        }

        public final Collection<Role> getRoles() {
            return this.roles;
        }

        @Override
        public final Builder roles(Collection<Role> roles) {
            this.roles = _roleListTypeCopier.copy(roles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roles(Role ... roles) {
            if (this.roles == null) {
                this.roles = new SdkInternalList<Role>(roles.length);
            }
            for (Role e : roles) {
                this.roles.add(e);
            }
            return this;
        }

        public final void setRoles(Collection<Role> roles) {
            this.roles = _roleListTypeCopier.copy(roles);
        }

        @SafeVarargs
        public final void setRoles(Role ... roles) {
            if (this.roles == null) {
                this.roles = new SdkInternalList<Role>(roles.length);
            }
            for (Role e : roles) {
                this.roles.add(e);
            }
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public ListRolesResponse build() {
            return new ListRolesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListRolesResponse> {
        public Builder roles(Collection<Role> var1);

        public Builder roles(Role ... var1);

        public Builder isTruncated(Boolean var1);

        public Builder marker(String var1);
    }
}

