/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.iam.model.SigningCertificate;
import software.amazon.awssdk.services.iam.model._certificateListTypeCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListSigningCertificatesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListSigningCertificatesResponse> {
    private final List<SigningCertificate> certificates;
    private final Boolean isTruncated;
    private final String marker;

    private ListSigningCertificatesResponse(BuilderImpl builder) {
        this.certificates = builder.certificates;
        this.isTruncated = builder.isTruncated;
        this.marker = builder.marker;
    }

    public List<SigningCertificate> certificates() {
        return this.certificates;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public String marker() {
        return this.marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.certificates() == null ? 0 : this.certificates().hashCode());
        hashCode = 31 * hashCode + (this.isTruncated() == null ? 0 : this.isTruncated().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSigningCertificatesResponse)) {
            return false;
        }
        ListSigningCertificatesResponse other = (ListSigningCertificatesResponse)obj;
        if (other.certificates() == null ^ this.certificates() == null) {
            return false;
        }
        if (other.certificates() != null && !other.certificates().equals(this.certificates())) {
            return false;
        }
        if (other.isTruncated() == null ^ this.isTruncated() == null) {
            return false;
        }
        if (other.isTruncated() != null && !other.isTruncated().equals(this.isTruncated())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        return other.marker() == null || other.marker().equals(this.marker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.certificates() != null) {
            sb.append("Certificates: ").append(this.certificates()).append(",");
        }
        if (this.isTruncated() != null) {
            sb.append("IsTruncated: ").append(this.isTruncated()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<SigningCertificate> certificates = new SdkInternalList<SigningCertificate>();
        private Boolean isTruncated;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSigningCertificatesResponse model) {
            this.setCertificates(model.certificates);
            this.setIsTruncated(model.isTruncated);
            this.setMarker(model.marker);
        }

        public final Collection<SigningCertificate> getCertificates() {
            return this.certificates;
        }

        @Override
        public final Builder certificates(Collection<SigningCertificate> certificates) {
            this.certificates = _certificateListTypeCopier.copy(certificates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificates(SigningCertificate ... certificates) {
            if (this.certificates == null) {
                this.certificates = new SdkInternalList<SigningCertificate>(certificates.length);
            }
            for (SigningCertificate e : certificates) {
                this.certificates.add(e);
            }
            return this;
        }

        public final void setCertificates(Collection<SigningCertificate> certificates) {
            this.certificates = _certificateListTypeCopier.copy(certificates);
        }

        @SafeVarargs
        public final void setCertificates(SigningCertificate ... certificates) {
            if (this.certificates == null) {
                this.certificates = new SdkInternalList<SigningCertificate>(certificates.length);
            }
            for (SigningCertificate e : certificates) {
                this.certificates.add(e);
            }
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public ListSigningCertificatesResponse build() {
            return new ListSigningCertificatesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListSigningCertificatesResponse> {
        public Builder certificates(Collection<SigningCertificate> var1);

        public Builder certificates(SigningCertificate ... var1);

        public Builder isTruncated(Boolean var1);

        public Builder marker(String var1);
    }
}

