/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Date;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class LoginProfile
implements ToCopyableBuilder<Builder, LoginProfile> {
    private final String userName;
    private final Date createDate;
    private final Boolean passwordResetRequired;

    private LoginProfile(BuilderImpl builder) {
        this.userName = builder.userName;
        this.createDate = builder.createDate;
        this.passwordResetRequired = builder.passwordResetRequired;
    }

    public String userName() {
        return this.userName;
    }

    public Date createDate() {
        return this.createDate;
    }

    public Boolean passwordResetRequired() {
        return this.passwordResetRequired;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.userName() == null ? 0 : this.userName().hashCode());
        hashCode = 31 * hashCode + (this.createDate() == null ? 0 : this.createDate().hashCode());
        hashCode = 31 * hashCode + (this.passwordResetRequired() == null ? 0 : this.passwordResetRequired().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoginProfile)) {
            return false;
        }
        LoginProfile other = (LoginProfile)obj;
        if (other.userName() == null ^ this.userName() == null) {
            return false;
        }
        if (other.userName() != null && !other.userName().equals(this.userName())) {
            return false;
        }
        if (other.createDate() == null ^ this.createDate() == null) {
            return false;
        }
        if (other.createDate() != null && !other.createDate().equals(this.createDate())) {
            return false;
        }
        if (other.passwordResetRequired() == null ^ this.passwordResetRequired() == null) {
            return false;
        }
        return other.passwordResetRequired() == null || other.passwordResetRequired().equals(this.passwordResetRequired());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.userName() != null) {
            sb.append("UserName: ").append(this.userName()).append(",");
        }
        if (this.createDate() != null) {
            sb.append("CreateDate: ").append(this.createDate()).append(",");
        }
        if (this.passwordResetRequired() != null) {
            sb.append("PasswordResetRequired: ").append(this.passwordResetRequired()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String userName;
        private Date createDate;
        private Boolean passwordResetRequired;

        private BuilderImpl() {
        }

        private BuilderImpl(LoginProfile model) {
            this.setUserName(model.userName);
            this.setCreateDate(model.createDate);
            this.setPasswordResetRequired(model.passwordResetRequired);
        }

        public final String getUserName() {
            return this.userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final Date getCreateDate() {
            return this.createDate;
        }

        @Override
        public final Builder createDate(Date createDate) {
            this.createDate = StandardMemberCopier.copy(createDate);
            return this;
        }

        public final void setCreateDate(Date createDate) {
            this.createDate = StandardMemberCopier.copy(createDate);
        }

        public final Boolean getPasswordResetRequired() {
            return this.passwordResetRequired;
        }

        @Override
        public final Builder passwordResetRequired(Boolean passwordResetRequired) {
            this.passwordResetRequired = passwordResetRequired;
            return this;
        }

        public final void setPasswordResetRequired(Boolean passwordResetRequired) {
            this.passwordResetRequired = passwordResetRequired;
        }

        @Override
        public LoginProfile build() {
            return new LoginProfile(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LoginProfile> {
        public Builder userName(String var1);

        public Builder createDate(Date var1);

        public Builder passwordResetRequired(Boolean var1);
    }
}

