/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Date;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class MFADevice
implements ToCopyableBuilder<Builder, MFADevice> {
    private final String userName;
    private final String serialNumber;
    private final Date enableDate;

    private MFADevice(BuilderImpl builder) {
        this.userName = builder.userName;
        this.serialNumber = builder.serialNumber;
        this.enableDate = builder.enableDate;
    }

    public String userName() {
        return this.userName;
    }

    public String serialNumber() {
        return this.serialNumber;
    }

    public Date enableDate() {
        return this.enableDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.userName() == null ? 0 : this.userName().hashCode());
        hashCode = 31 * hashCode + (this.serialNumber() == null ? 0 : this.serialNumber().hashCode());
        hashCode = 31 * hashCode + (this.enableDate() == null ? 0 : this.enableDate().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MFADevice)) {
            return false;
        }
        MFADevice other = (MFADevice)obj;
        if (other.userName() == null ^ this.userName() == null) {
            return false;
        }
        if (other.userName() != null && !other.userName().equals(this.userName())) {
            return false;
        }
        if (other.serialNumber() == null ^ this.serialNumber() == null) {
            return false;
        }
        if (other.serialNumber() != null && !other.serialNumber().equals(this.serialNumber())) {
            return false;
        }
        if (other.enableDate() == null ^ this.enableDate() == null) {
            return false;
        }
        return other.enableDate() == null || other.enableDate().equals(this.enableDate());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.userName() != null) {
            sb.append("UserName: ").append(this.userName()).append(",");
        }
        if (this.serialNumber() != null) {
            sb.append("SerialNumber: ").append(this.serialNumber()).append(",");
        }
        if (this.enableDate() != null) {
            sb.append("EnableDate: ").append(this.enableDate()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String userName;
        private String serialNumber;
        private Date enableDate;

        private BuilderImpl() {
        }

        private BuilderImpl(MFADevice model) {
            this.setUserName(model.userName);
            this.setSerialNumber(model.serialNumber);
            this.setEnableDate(model.enableDate);
        }

        public final String getUserName() {
            return this.userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getSerialNumber() {
            return this.serialNumber;
        }

        @Override
        public final Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            return this;
        }

        public final void setSerialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
        }

        public final Date getEnableDate() {
            return this.enableDate;
        }

        @Override
        public final Builder enableDate(Date enableDate) {
            this.enableDate = StandardMemberCopier.copy(enableDate);
            return this;
        }

        public final void setEnableDate(Date enableDate) {
            this.enableDate = StandardMemberCopier.copy(enableDate);
        }

        @Override
        public MFADevice build() {
            return new MFADevice(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MFADevice> {
        public Builder userName(String var1);

        public Builder serialNumber(String var1);

        public Builder enableDate(Date var1);
    }
}

