/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Position
implements ToCopyableBuilder<Builder, Position> {
    private final Integer line;
    private final Integer column;

    private Position(BuilderImpl builder) {
        this.line = builder.line;
        this.column = builder.column;
    }

    public Integer line() {
        return this.line;
    }

    public Integer column() {
        return this.column;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.line() == null ? 0 : this.line().hashCode());
        hashCode = 31 * hashCode + (this.column() == null ? 0 : this.column().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Position)) {
            return false;
        }
        Position other = (Position)obj;
        if (other.line() == null ^ this.line() == null) {
            return false;
        }
        if (other.line() != null && !other.line().equals(this.line())) {
            return false;
        }
        if (other.column() == null ^ this.column() == null) {
            return false;
        }
        return other.column() == null || other.column().equals(this.column());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.line() != null) {
            sb.append("Line: ").append(this.line()).append(",");
        }
        if (this.column() != null) {
            sb.append("Column: ").append(this.column()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Integer line;
        private Integer column;

        private BuilderImpl() {
        }

        private BuilderImpl(Position model) {
            this.setLine(model.line);
            this.setColumn(model.column);
        }

        public final Integer getLine() {
            return this.line;
        }

        @Override
        public final Builder line(Integer line) {
            this.line = line;
            return this;
        }

        public final void setLine(Integer line) {
            this.line = line;
        }

        public final Integer getColumn() {
            return this.column;
        }

        @Override
        public final Builder column(Integer column) {
            this.column = column;
            return this;
        }

        public final void setColumn(Integer column) {
            this.column = column;
        }

        @Override
        public Position build() {
            return new Position(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Position> {
        public Builder line(Integer var1);

        public Builder column(Integer var1);
    }
}

