/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutRolePolicyRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, PutRolePolicyRequest> {
    private final String roleName;
    private final String policyName;
    private final String policyDocument;

    private PutRolePolicyRequest(BuilderImpl builder) {
        this.roleName = builder.roleName;
        this.policyName = builder.policyName;
        this.policyDocument = builder.policyDocument;
    }

    public String roleName() {
        return this.roleName;
    }

    public String policyName() {
        return this.policyName;
    }

    public String policyDocument() {
        return this.policyDocument;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.roleName() == null ? 0 : this.roleName().hashCode());
        hashCode = 31 * hashCode + (this.policyName() == null ? 0 : this.policyName().hashCode());
        hashCode = 31 * hashCode + (this.policyDocument() == null ? 0 : this.policyDocument().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRolePolicyRequest)) {
            return false;
        }
        PutRolePolicyRequest other = (PutRolePolicyRequest)obj;
        if (other.roleName() == null ^ this.roleName() == null) {
            return false;
        }
        if (other.roleName() != null && !other.roleName().equals(this.roleName())) {
            return false;
        }
        if (other.policyName() == null ^ this.policyName() == null) {
            return false;
        }
        if (other.policyName() != null && !other.policyName().equals(this.policyName())) {
            return false;
        }
        if (other.policyDocument() == null ^ this.policyDocument() == null) {
            return false;
        }
        return other.policyDocument() == null || other.policyDocument().equals(this.policyDocument());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.roleName() != null) {
            sb.append("RoleName: ").append(this.roleName()).append(",");
        }
        if (this.policyName() != null) {
            sb.append("PolicyName: ").append(this.policyName()).append(",");
        }
        if (this.policyDocument() != null) {
            sb.append("PolicyDocument: ").append(this.policyDocument()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String roleName;
        private String policyName;
        private String policyDocument;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRolePolicyRequest model) {
            this.setRoleName(model.roleName);
            this.setPolicyName(model.policyName);
            this.setPolicyDocument(model.policyDocument);
        }

        public final String getRoleName() {
            return this.roleName;
        }

        @Override
        public final Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public final void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        public final String getPolicyName() {
            return this.policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public final String getPolicyDocument() {
            return this.policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        @Override
        public PutRolePolicyRequest build() {
            return new PutRolePolicyRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PutRolePolicyRequest> {
        public Builder roleName(String var1);

        public Builder policyName(String var1);

        public Builder policyDocument(String var1);
    }
}

