/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Date;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Role
implements ToCopyableBuilder<Builder, Role> {
    private final String path;
    private final String roleName;
    private final String roleId;
    private final String arn;
    private final Date createDate;
    private final String assumeRolePolicyDocument;
    private final String description;

    private Role(BuilderImpl builder) {
        this.path = builder.path;
        this.roleName = builder.roleName;
        this.roleId = builder.roleId;
        this.arn = builder.arn;
        this.createDate = builder.createDate;
        this.assumeRolePolicyDocument = builder.assumeRolePolicyDocument;
        this.description = builder.description;
    }

    public String path() {
        return this.path;
    }

    public String roleName() {
        return this.roleName;
    }

    public String roleId() {
        return this.roleId;
    }

    public String arn() {
        return this.arn;
    }

    public Date createDate() {
        return this.createDate;
    }

    public String assumeRolePolicyDocument() {
        return this.assumeRolePolicyDocument;
    }

    public String description() {
        return this.description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.path() == null ? 0 : this.path().hashCode());
        hashCode = 31 * hashCode + (this.roleName() == null ? 0 : this.roleName().hashCode());
        hashCode = 31 * hashCode + (this.roleId() == null ? 0 : this.roleId().hashCode());
        hashCode = 31 * hashCode + (this.arn() == null ? 0 : this.arn().hashCode());
        hashCode = 31 * hashCode + (this.createDate() == null ? 0 : this.createDate().hashCode());
        hashCode = 31 * hashCode + (this.assumeRolePolicyDocument() == null ? 0 : this.assumeRolePolicyDocument().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Role)) {
            return false;
        }
        Role other = (Role)obj;
        if (other.path() == null ^ this.path() == null) {
            return false;
        }
        if (other.path() != null && !other.path().equals(this.path())) {
            return false;
        }
        if (other.roleName() == null ^ this.roleName() == null) {
            return false;
        }
        if (other.roleName() != null && !other.roleName().equals(this.roleName())) {
            return false;
        }
        if (other.roleId() == null ^ this.roleId() == null) {
            return false;
        }
        if (other.roleId() != null && !other.roleId().equals(this.roleId())) {
            return false;
        }
        if (other.arn() == null ^ this.arn() == null) {
            return false;
        }
        if (other.arn() != null && !other.arn().equals(this.arn())) {
            return false;
        }
        if (other.createDate() == null ^ this.createDate() == null) {
            return false;
        }
        if (other.createDate() != null && !other.createDate().equals(this.createDate())) {
            return false;
        }
        if (other.assumeRolePolicyDocument() == null ^ this.assumeRolePolicyDocument() == null) {
            return false;
        }
        if (other.assumeRolePolicyDocument() != null && !other.assumeRolePolicyDocument().equals(this.assumeRolePolicyDocument())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        return other.description() == null || other.description().equals(this.description());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.path() != null) {
            sb.append("Path: ").append(this.path()).append(",");
        }
        if (this.roleName() != null) {
            sb.append("RoleName: ").append(this.roleName()).append(",");
        }
        if (this.roleId() != null) {
            sb.append("RoleId: ").append(this.roleId()).append(",");
        }
        if (this.arn() != null) {
            sb.append("Arn: ").append(this.arn()).append(",");
        }
        if (this.createDate() != null) {
            sb.append("CreateDate: ").append(this.createDate()).append(",");
        }
        if (this.assumeRolePolicyDocument() != null) {
            sb.append("AssumeRolePolicyDocument: ").append(this.assumeRolePolicyDocument()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String path;
        private String roleName;
        private String roleId;
        private String arn;
        private Date createDate;
        private String assumeRolePolicyDocument;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(Role model) {
            this.setPath(model.path);
            this.setRoleName(model.roleName);
            this.setRoleId(model.roleId);
            this.setArn(model.arn);
            this.setCreateDate(model.createDate);
            this.setAssumeRolePolicyDocument(model.assumeRolePolicyDocument);
            this.setDescription(model.description);
        }

        public final String getPath() {
            return this.path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        public final String getRoleName() {
            return this.roleName;
        }

        @Override
        public final Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public final void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        public final String getRoleId() {
            return this.roleId;
        }

        @Override
        public final Builder roleId(String roleId) {
            this.roleId = roleId;
            return this;
        }

        public final void setRoleId(String roleId) {
            this.roleId = roleId;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Date getCreateDate() {
            return this.createDate;
        }

        @Override
        public final Builder createDate(Date createDate) {
            this.createDate = StandardMemberCopier.copy(createDate);
            return this;
        }

        public final void setCreateDate(Date createDate) {
            this.createDate = StandardMemberCopier.copy(createDate);
        }

        public final String getAssumeRolePolicyDocument() {
            return this.assumeRolePolicyDocument;
        }

        @Override
        public final Builder assumeRolePolicyDocument(String assumeRolePolicyDocument) {
            this.assumeRolePolicyDocument = assumeRolePolicyDocument;
            return this;
        }

        public final void setAssumeRolePolicyDocument(String assumeRolePolicyDocument) {
            this.assumeRolePolicyDocument = assumeRolePolicyDocument;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public Role build() {
            return new Role(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Role> {
        public Builder path(String var1);

        public Builder roleName(String var1);

        public Builder roleId(String var1);

        public Builder arn(String var1);

        public Builder createDate(Date var1);

        public Builder assumeRolePolicyDocument(String var1);

        public Builder description(String var1);
    }
}

